// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SubjectSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Approval Stage.
 */
public class AccessPackageApprovalStage implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Duration Before Automatic Denial.
     * The number of days that a request can be pending a response before it is automatically denied.
     */
    @SerializedName(value = "durationBeforeAutomaticDenial", alternate = {"DurationBeforeAutomaticDenial"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration durationBeforeAutomaticDenial;

    /**
     * The Duration Before Escalation.
     * If escalation is required, the time a request can be pending a response from a primary approver.
     */
    @SerializedName(value = "durationBeforeEscalation", alternate = {"DurationBeforeEscalation"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration durationBeforeEscalation;

    /**
     * The Escalation Approvers.
     * If escalation is enabled and the primary approvers do not respond before the escalation time, the escalationApprovers are the users who will be asked to approve requests.
     */
    @SerializedName(value = "escalationApprovers", alternate = {"EscalationApprovers"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> escalationApprovers;

    /**
     * The Fallback Escalation Approvers.
     * The subjects, typically users, who are the fallback escalation approvers.
     */
    @SerializedName(value = "fallbackEscalationApprovers", alternate = {"FallbackEscalationApprovers"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> fallbackEscalationApprovers;

    /**
     * The Fallback Primary Approvers.
     * The subjects, typically users, who are the fallback primary approvers.
     */
    @SerializedName(value = "fallbackPrimaryApprovers", alternate = {"FallbackPrimaryApprovers"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> fallbackPrimaryApprovers;

    /**
     * The Is Approver Justification Required.
     * Indicates whether the approver is required to provide a justification for approving a request.
     */
    @SerializedName(value = "isApproverJustificationRequired", alternate = {"IsApproverJustificationRequired"})
    @Expose
	@Nullable
    public Boolean isApproverJustificationRequired;

    /**
     * The Is Escalation Enabled.
     * If true, then one or more escalationApprovers are configured in this approval stage.
     */
    @SerializedName(value = "isEscalationEnabled", alternate = {"IsEscalationEnabled"})
    @Expose
	@Nullable
    public Boolean isEscalationEnabled;

    /**
     * The Primary Approvers.
     * The subjects, typically users, who will be asked to approve requests. A collection of singleUser, groupMembers, requestorManager, internalSponsors or externalSponsors.
     */
    @SerializedName(value = "primaryApprovers", alternate = {"PrimaryApprovers"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> primaryApprovers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
