// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Presence Set Presence Parameter Set.
 */
public class PresenceSetPresenceParameterSet {
    /**
     * The session Id.
     * 
     */
    @SerializedName(value = "sessionId", alternate = {"SessionId"})
    @Expose
	@Nullable
    public String sessionId;

    /**
     * The availability.
     * 
     */
    @SerializedName(value = "availability", alternate = {"Availability"})
    @Expose
	@Nullable
    public String availability;

    /**
     * The activity.
     * 
     */
    @SerializedName(value = "activity", alternate = {"Activity"})
    @Expose
	@Nullable
    public String activity;

    /**
     * The expiration Duration.
     * 
     */
    @SerializedName(value = "expirationDuration", alternate = {"ExpirationDuration"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration expirationDuration;


    /**
     * Instiaciates a new PresenceSetPresenceParameterSet
     */
    public PresenceSetPresenceParameterSet() {}
    /**
     * Instiaciates a new PresenceSetPresenceParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PresenceSetPresenceParameterSet(@Nonnull final PresenceSetPresenceParameterSetBuilder builder) {
        this.sessionId = builder.sessionId;
        this.availability = builder.availability;
        this.activity = builder.activity;
        this.expirationDuration = builder.expirationDuration;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PresenceSetPresenceParameterSetBuilder newBuilder() {
        return new PresenceSetPresenceParameterSetBuilder();
    }
    /**
     * Fluent builder for the PresenceSetPresenceParameterSet
     */
    public static final class PresenceSetPresenceParameterSetBuilder {
        /**
         * The sessionId parameter value
         */
        @Nullable
        protected String sessionId;
        /**
         * Sets the SessionId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PresenceSetPresenceParameterSetBuilder withSessionId(@Nullable final String val) {
            this.sessionId = val;
            return this;
        }
        /**
         * The availability parameter value
         */
        @Nullable
        protected String availability;
        /**
         * Sets the Availability
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PresenceSetPresenceParameterSetBuilder withAvailability(@Nullable final String val) {
            this.availability = val;
            return this;
        }
        /**
         * The activity parameter value
         */
        @Nullable
        protected String activity;
        /**
         * Sets the Activity
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PresenceSetPresenceParameterSetBuilder withActivity(@Nullable final String val) {
            this.activity = val;
            return this;
        }
        /**
         * The expirationDuration parameter value
         */
        @Nullable
        protected javax.xml.datatype.Duration expirationDuration;
        /**
         * Sets the ExpirationDuration
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PresenceSetPresenceParameterSetBuilder withExpirationDuration(@Nullable final javax.xml.datatype.Duration val) {
            this.expirationDuration = val;
            return this;
        }
        /**
         * Instanciates a new PresenceSetPresenceParameterSetBuilder
         */
        @Nullable
        protected PresenceSetPresenceParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PresenceSetPresenceParameterSet build() {
            return new PresenceSetPresenceParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.sessionId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sessionId", sessionId));
        }
        if(this.availability != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("availability", availability));
        }
        if(this.activity != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("activity", activity));
        }
        if(this.expirationDuration != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("expirationDuration", expirationDuration));
        }
        return result;
    }
}
