// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Workbook;
import com.microsoft.graph.models.WorkbookSessionInfo;
import com.microsoft.graph.models.WorkbookTableRow;
import com.microsoft.graph.requests.WorkbookApplicationRequestBuilder;
import com.microsoft.graph.requests.WorkbookCommentCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookCommentRequestBuilder;
import com.microsoft.graph.requests.WorkbookFunctionsRequestBuilder;
import com.microsoft.graph.requests.WorkbookNamedItemCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookNamedItemRequestBuilder;
import com.microsoft.graph.requests.WorkbookOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookOperationRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Request.
 */
public class WorkbookRequest extends BaseRequest<Workbook> {
	
    /**
     * The request for the Workbook
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Workbook.class);
    }

    /**
     * Gets the Workbook from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Workbook> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Workbook from the service
     *
     * @return the Workbook from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Workbook get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Workbook> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Workbook delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Workbook with a source
     *
     * @param sourceWorkbook the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Workbook> patchAsync(@Nonnull final Workbook sourceWorkbook) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbook);
    }

    /**
     * Patches this Workbook with a source
     *
     * @param sourceWorkbook the source object with updates
     * @return the updated Workbook
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Workbook patch(@Nonnull final Workbook sourceWorkbook) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbook);
    }

    /**
     * Creates a Workbook with a new object
     *
     * @param newWorkbook the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Workbook> postAsync(@Nonnull final Workbook newWorkbook) {
        return sendAsync(HttpMethod.POST, newWorkbook);
    }

    /**
     * Creates a Workbook with a new object
     *
     * @param newWorkbook the new object to create
     * @return the created Workbook
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Workbook post(@Nonnull final Workbook newWorkbook) throws ClientException {
        return send(HttpMethod.POST, newWorkbook);
    }

    /**
     * Creates a Workbook with a new object
     *
     * @param newWorkbook the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Workbook> putAsync(@Nonnull final Workbook newWorkbook) {
        return sendAsync(HttpMethod.PUT, newWorkbook);
    }

    /**
     * Creates a Workbook with a new object
     *
     * @param newWorkbook the object to create/update
     * @return the created Workbook
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Workbook put(@Nonnull final Workbook newWorkbook) throws ClientException {
        return send(HttpMethod.PUT, newWorkbook);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

