// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.requests.ContentTypeWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnLinkCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnLinkRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.ContentTypeAssociateWithHubSitesParameterSet;
import com.microsoft.graph.models.ContentTypeCopyToDefaultContentLocationParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Request Builder.
 */
public class ContentTypeRequestBuilder extends BaseRequestBuilder<ContentType> {

    /**
     * The request builder for the ContentType
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContentTypeRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ContentTypeRequest instance
     */
    @Nonnull
    public ContentTypeRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ContentTypeRequest instance
     */
    @Nonnull
    public ContentTypeRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.ContentTypeRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for ContentType
     *
     * @return the ContentTypeWithReferenceRequestBuilder instance
     */
    @Nonnull
    public ContentTypeWithReferenceRequestBuilder base() {
        return new ContentTypeWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("base"), getClient(), null);
    }
    /**
     *  Gets a request builder for the ContentType collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public ContentTypeCollectionWithReferencesRequestBuilder baseTypes() {
        return new ContentTypeCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("baseTypes"), getClient(), null);
    }

    /**
     * Gets a request builder for the ContentType item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public ContentTypeWithReferenceRequestBuilder baseTypes(@Nonnull final String id) {
        return new ContentTypeWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("baseTypes") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ColumnLink collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public ColumnLinkCollectionRequestBuilder columnLinks() {
        return new ColumnLinkCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("columnLinks"), getClient(), null);
    }

    /**
     * Gets a request builder for the ColumnLink item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public ColumnLinkRequestBuilder columnLinks(@Nonnull final String id) {
        return new ColumnLinkRequestBuilder(getRequestUrlWithAdditionalSegment("columnLinks") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ColumnDefinition collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public ColumnDefinitionCollectionWithReferencesRequestBuilder columnPositions() {
        return new ColumnDefinitionCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("columnPositions"), getClient(), null);
    }

    /**
     * Gets a request builder for the ColumnDefinition item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public ColumnDefinitionWithReferenceRequestBuilder columnPositions(@Nonnull final String id) {
        return new ColumnDefinitionWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("columnPositions") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ColumnDefinition collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public ColumnDefinitionCollectionRequestBuilder columns() {
        return new ColumnDefinitionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("columns"), getClient(), null);
    }

    /**
     * Gets a request builder for the ColumnDefinition item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public ColumnDefinitionRequestBuilder columns(@Nonnull final String id) {
        return new ColumnDefinitionRequestBuilder(getRequestUrlWithAdditionalSegment("columns") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ContentTypePublishRequestBuilder publish() {
        return new ContentTypePublishRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.publish"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ContentTypeUnpublishRequestBuilder unpublish() {
        return new ContentTypeUnpublishRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unpublish"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ContentTypeAssociateWithHubSitesRequestBuilder associateWithHubSites(@Nonnull final ContentTypeAssociateWithHubSitesParameterSet parameters) {
        return new ContentTypeAssociateWithHubSitesRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.associateWithHubSites"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ContentTypeCopyToDefaultContentLocationRequestBuilder copyToDefaultContentLocation(@Nonnull final ContentTypeCopyToDefaultContentLocationParameterSet parameters) {
        return new ContentTypeCopyToDefaultContentLocationRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.copyToDefaultContentLocation"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public ContentTypeIsPublishedRequestBuilder isPublished() {
        return new ContentTypeIsPublishedRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.isPublished"), getClient(), null);
    }
}
