// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Trim Mean Parameter Set.
 */
public class WorkbookFunctionsTrimMeanParameterSet {
    /**
     * The array.
     * 
     */
    @SerializedName(value = "array", alternate = {"Array"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement array;

    /**
     * The percent.
     * 
     */
    @SerializedName(value = "percent", alternate = {"Percent"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement percent;


    /**
     * Instiaciates a new WorkbookFunctionsTrimMeanParameterSet
     */
    public WorkbookFunctionsTrimMeanParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsTrimMeanParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsTrimMeanParameterSet(@Nonnull final WorkbookFunctionsTrimMeanParameterSetBuilder builder) {
        this.array = builder.array;
        this.percent = builder.percent;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsTrimMeanParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsTrimMeanParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsTrimMeanParameterSet
     */
    public static final class WorkbookFunctionsTrimMeanParameterSetBuilder {
        /**
         * The array parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement array;
        /**
         * Sets the Array
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsTrimMeanParameterSetBuilder withArray(@Nullable final com.google.gson.JsonElement val) {
            this.array = val;
            return this;
        }
        /**
         * The percent parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement percent;
        /**
         * Sets the Percent
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsTrimMeanParameterSetBuilder withPercent(@Nullable final com.google.gson.JsonElement val) {
            this.percent = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsTrimMeanParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsTrimMeanParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsTrimMeanParameterSet build() {
            return new WorkbookFunctionsTrimMeanParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.array != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("array", array));
        }
        if(this.percent != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("percent", percent));
        }
        return result;
    }
}
