// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Substitute Parameter Set.
 */
public class WorkbookFunctionsSubstituteParameterSet {
    /**
     * The text.
     * 
     */
    @SerializedName(value = "text", alternate = {"Text"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement text;

    /**
     * The old Text.
     * 
     */
    @SerializedName(value = "oldText", alternate = {"OldText"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement oldText;

    /**
     * The new Text.
     * 
     */
    @SerializedName(value = "newText", alternate = {"NewText"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement newText;

    /**
     * The instance Num.
     * 
     */
    @SerializedName(value = "instanceNum", alternate = {"InstanceNum"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement instanceNum;


    /**
     * Instiaciates a new WorkbookFunctionsSubstituteParameterSet
     */
    public WorkbookFunctionsSubstituteParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsSubstituteParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsSubstituteParameterSet(@Nonnull final WorkbookFunctionsSubstituteParameterSetBuilder builder) {
        this.text = builder.text;
        this.oldText = builder.oldText;
        this.newText = builder.newText;
        this.instanceNum = builder.instanceNum;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsSubstituteParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsSubstituteParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsSubstituteParameterSet
     */
    public static final class WorkbookFunctionsSubstituteParameterSetBuilder {
        /**
         * The text parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement text;
        /**
         * Sets the Text
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSubstituteParameterSetBuilder withText(@Nullable final com.google.gson.JsonElement val) {
            this.text = val;
            return this;
        }
        /**
         * The oldText parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement oldText;
        /**
         * Sets the OldText
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSubstituteParameterSetBuilder withOldText(@Nullable final com.google.gson.JsonElement val) {
            this.oldText = val;
            return this;
        }
        /**
         * The newText parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement newText;
        /**
         * Sets the NewText
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSubstituteParameterSetBuilder withNewText(@Nullable final com.google.gson.JsonElement val) {
            this.newText = val;
            return this;
        }
        /**
         * The instanceNum parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement instanceNum;
        /**
         * Sets the InstanceNum
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsSubstituteParameterSetBuilder withInstanceNum(@Nullable final com.google.gson.JsonElement val) {
            this.instanceNum = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsSubstituteParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsSubstituteParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsSubstituteParameterSet build() {
            return new WorkbookFunctionsSubstituteParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.text != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("text", text));
        }
        if(this.oldText != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("oldText", oldText));
        }
        if(this.newText != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("newText", newText));
        }
        if(this.instanceNum != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("instanceNum", instanceNum));
        }
        return result;
    }
}
