// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Thumbnail;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Thumbnail Set.
 */
public class ThumbnailSet extends Entity implements IJsonBackedObject {


    /**
     * The Large.
     * A 1920x1920 scaled thumbnail.
     */
    @SerializedName(value = "large", alternate = {"Large"})
    @Expose
	@Nullable
    public Thumbnail large;

    /**
     * The Medium.
     * A 176x176 scaled thumbnail.
     */
    @SerializedName(value = "medium", alternate = {"Medium"})
    @Expose
	@Nullable
    public Thumbnail medium;

    /**
     * The Small.
     * A 48x48 cropped thumbnail.
     */
    @SerializedName(value = "small", alternate = {"Small"})
    @Expose
	@Nullable
    public Thumbnail small;

    /**
     * The Source.
     * A custom thumbnail image or the original image used to generate other thumbnails.
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
	@Nullable
    public Thumbnail source;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
