// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SubjectSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Requestor Settings.
 */
public class AccessPackageAssignmentRequestorSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Custom Assignment Schedule.
     * If false, the requestor is not permitted to include a schedule in their request.
     */
    @SerializedName(value = "allowCustomAssignmentSchedule", alternate = {"AllowCustomAssignmentSchedule"})
    @Expose
	@Nullable
    public Boolean allowCustomAssignmentSchedule;

    /**
     * The Enable On Behalf Requestors To Add Access.
     * If true, allows on-behalf-of requestors to create a request to add access for another principal.
     */
    @SerializedName(value = "enableOnBehalfRequestorsToAddAccess", alternate = {"EnableOnBehalfRequestorsToAddAccess"})
    @Expose
	@Nullable
    public Boolean enableOnBehalfRequestorsToAddAccess;

    /**
     * The Enable On Behalf Requestors To Remove Access.
     * If true, allows on-behalf-of requestors to create a request to remove access for another principal.
     */
    @SerializedName(value = "enableOnBehalfRequestorsToRemoveAccess", alternate = {"EnableOnBehalfRequestorsToRemoveAccess"})
    @Expose
	@Nullable
    public Boolean enableOnBehalfRequestorsToRemoveAccess;

    /**
     * The Enable On Behalf Requestors To Update Access.
     * If true, allows on-behalf-of requestors to create a request to update access for another principal.
     */
    @SerializedName(value = "enableOnBehalfRequestorsToUpdateAccess", alternate = {"EnableOnBehalfRequestorsToUpdateAccess"})
    @Expose
	@Nullable
    public Boolean enableOnBehalfRequestorsToUpdateAccess;

    /**
     * The Enable Targets To Self Add Access.
     * If true, allows requestors to create a request to add access for themselves.
     */
    @SerializedName(value = "enableTargetsToSelfAddAccess", alternate = {"EnableTargetsToSelfAddAccess"})
    @Expose
	@Nullable
    public Boolean enableTargetsToSelfAddAccess;

    /**
     * The Enable Targets To Self Remove Access.
     * If true, allows requestors to create a request to remove their access.
     */
    @SerializedName(value = "enableTargetsToSelfRemoveAccess", alternate = {"EnableTargetsToSelfRemoveAccess"})
    @Expose
	@Nullable
    public Boolean enableTargetsToSelfRemoveAccess;

    /**
     * The Enable Targets To Self Update Access.
     * If true, allows requestors to create a request to update their access.
     */
    @SerializedName(value = "enableTargetsToSelfUpdateAccess", alternate = {"EnableTargetsToSelfUpdateAccess"})
    @Expose
	@Nullable
    public Boolean enableTargetsToSelfUpdateAccess;

    /**
     * The On Behalf Requestors.
     * The principals who can request on-behalf-of others.
     */
    @SerializedName(value = "onBehalfRequestors", alternate = {"OnBehalfRequestors"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> onBehalfRequestors;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
