// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Operation Request.
 */
public class WorkbookOperationRequest extends BaseRequest<WorkbookOperation> {
	
    /**
     * The request for the WorkbookOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookOperation.class);
    }

    /**
     * Gets the WorkbookOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookOperation from the service
     *
     * @return the WorkbookOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookOperation with a source
     *
     * @param sourceWorkbookOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookOperation> patchAsync(@Nonnull final WorkbookOperation sourceWorkbookOperation) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookOperation);
    }

    /**
     * Patches this WorkbookOperation with a source
     *
     * @param sourceWorkbookOperation the source object with updates
     * @return the updated WorkbookOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookOperation patch(@Nonnull final WorkbookOperation sourceWorkbookOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookOperation);
    }

    /**
     * Creates a WorkbookOperation with a new object
     *
     * @param newWorkbookOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookOperation> postAsync(@Nonnull final WorkbookOperation newWorkbookOperation) {
        return sendAsync(HttpMethod.POST, newWorkbookOperation);
    }

    /**
     * Creates a WorkbookOperation with a new object
     *
     * @param newWorkbookOperation the new object to create
     * @return the created WorkbookOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookOperation post(@Nonnull final WorkbookOperation newWorkbookOperation) throws ClientException {
        return send(HttpMethod.POST, newWorkbookOperation);
    }

    /**
     * Creates a WorkbookOperation with a new object
     *
     * @param newWorkbookOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookOperation> putAsync(@Nonnull final WorkbookOperation newWorkbookOperation) {
        return sendAsync(HttpMethod.PUT, newWorkbookOperation);
    }

    /**
     * Creates a WorkbookOperation with a new object
     *
     * @param newWorkbookOperation the object to create/update
     * @return the created WorkbookOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookOperation put(@Nonnull final WorkbookOperation newWorkbookOperation) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

