// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServiceHealthIssue;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Health Issue Request.
 */
public class ServiceHealthIssueRequest extends BaseRequest<ServiceHealthIssue> {
	
    /**
     * The request for the ServiceHealthIssue
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ServiceHealthIssueRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServiceHealthIssue.class);
    }

    /**
     * Gets the ServiceHealthIssue from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealthIssue> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ServiceHealthIssue from the service
     *
     * @return the ServiceHealthIssue from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealthIssue get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealthIssue> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ServiceHealthIssue delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ServiceHealthIssue with a source
     *
     * @param sourceServiceHealthIssue the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealthIssue> patchAsync(@Nonnull final ServiceHealthIssue sourceServiceHealthIssue) {
        return sendAsync(HttpMethod.PATCH, sourceServiceHealthIssue);
    }

    /**
     * Patches this ServiceHealthIssue with a source
     *
     * @param sourceServiceHealthIssue the source object with updates
     * @return the updated ServiceHealthIssue
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealthIssue patch(@Nonnull final ServiceHealthIssue sourceServiceHealthIssue) throws ClientException {
        return send(HttpMethod.PATCH, sourceServiceHealthIssue);
    }

    /**
     * Creates a ServiceHealthIssue with a new object
     *
     * @param newServiceHealthIssue the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealthIssue> postAsync(@Nonnull final ServiceHealthIssue newServiceHealthIssue) {
        return sendAsync(HttpMethod.POST, newServiceHealthIssue);
    }

    /**
     * Creates a ServiceHealthIssue with a new object
     *
     * @param newServiceHealthIssue the new object to create
     * @return the created ServiceHealthIssue
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealthIssue post(@Nonnull final ServiceHealthIssue newServiceHealthIssue) throws ClientException {
        return send(HttpMethod.POST, newServiceHealthIssue);
    }

    /**
     * Creates a ServiceHealthIssue with a new object
     *
     * @param newServiceHealthIssue the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ServiceHealthIssue> putAsync(@Nonnull final ServiceHealthIssue newServiceHealthIssue) {
        return sendAsync(HttpMethod.PUT, newServiceHealthIssue);
    }

    /**
     * Creates a ServiceHealthIssue with a new object
     *
     * @param newServiceHealthIssue the object to create/update
     * @return the created ServiceHealthIssue
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ServiceHealthIssue put(@Nonnull final ServiceHealthIssue newServiceHealthIssue) throws ClientException {
        return send(HttpMethod.PUT, newServiceHealthIssue);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ServiceHealthIssueRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ServiceHealthIssueRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

