// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.NotificationMessageTemplate;
import com.microsoft.graph.requests.LocalizedNotificationMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.LocalizedNotificationMessageRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notification Message Template Request Builder.
 */
public class NotificationMessageTemplateRequestBuilder extends BaseRequestBuilder<NotificationMessageTemplate> {

    /**
     * The request builder for the NotificationMessageTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NotificationMessageTemplateRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the NotificationMessageTemplateRequest instance
     */
    @Nonnull
    public NotificationMessageTemplateRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the NotificationMessageTemplateRequest instance
     */
    @Nonnull
    public NotificationMessageTemplateRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.NotificationMessageTemplateRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the LocalizedNotificationMessage collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public LocalizedNotificationMessageCollectionRequestBuilder localizedNotificationMessages() {
        return new LocalizedNotificationMessageCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("localizedNotificationMessages"), getClient(), null);
    }

    /**
     * Gets a request builder for the LocalizedNotificationMessage item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public LocalizedNotificationMessageRequestBuilder localizedNotificationMessages(@Nonnull final String id) {
        return new LocalizedNotificationMessageRequestBuilder(getRequestUrlWithAdditionalSegment("localizedNotificationMessages") + "/" + id, getClient(), null);
    }

    /**
     * Sends test message using the specified notificationMessageTemplate in the default locale
     * @return the request builder
     */
    @Nonnull
    public NotificationMessageTemplateSendTestMessageRequestBuilder sendTestMessage() {
        return new NotificationMessageTemplateSendTestMessageRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.sendTestMessage"), getClient(), null);
    }
}
