// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CertificateBasedAuthConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Certificate Based Auth Configuration Request.
 */
public class CertificateBasedAuthConfigurationRequest extends BaseRequest<CertificateBasedAuthConfiguration> {
	
    /**
     * The request for the CertificateBasedAuthConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CertificateBasedAuthConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CertificateBasedAuthConfiguration.class);
    }

    /**
     * Gets the CertificateBasedAuthConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CertificateBasedAuthConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CertificateBasedAuthConfiguration from the service
     *
     * @return the CertificateBasedAuthConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CertificateBasedAuthConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CertificateBasedAuthConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CertificateBasedAuthConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CertificateBasedAuthConfiguration with a source
     *
     * @param sourceCertificateBasedAuthConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CertificateBasedAuthConfiguration> patchAsync(@Nonnull final CertificateBasedAuthConfiguration sourceCertificateBasedAuthConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceCertificateBasedAuthConfiguration);
    }

    /**
     * Patches this CertificateBasedAuthConfiguration with a source
     *
     * @param sourceCertificateBasedAuthConfiguration the source object with updates
     * @return the updated CertificateBasedAuthConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CertificateBasedAuthConfiguration patch(@Nonnull final CertificateBasedAuthConfiguration sourceCertificateBasedAuthConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceCertificateBasedAuthConfiguration);
    }

    /**
     * Creates a CertificateBasedAuthConfiguration with a new object
     *
     * @param newCertificateBasedAuthConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CertificateBasedAuthConfiguration> postAsync(@Nonnull final CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) {
        return sendAsync(HttpMethod.POST, newCertificateBasedAuthConfiguration);
    }

    /**
     * Creates a CertificateBasedAuthConfiguration with a new object
     *
     * @param newCertificateBasedAuthConfiguration the new object to create
     * @return the created CertificateBasedAuthConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CertificateBasedAuthConfiguration post(@Nonnull final CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) throws ClientException {
        return send(HttpMethod.POST, newCertificateBasedAuthConfiguration);
    }

    /**
     * Creates a CertificateBasedAuthConfiguration with a new object
     *
     * @param newCertificateBasedAuthConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CertificateBasedAuthConfiguration> putAsync(@Nonnull final CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) {
        return sendAsync(HttpMethod.PUT, newCertificateBasedAuthConfiguration);
    }

    /**
     * Creates a CertificateBasedAuthConfiguration with a new object
     *
     * @param newCertificateBasedAuthConfiguration the object to create/update
     * @return the created CertificateBasedAuthConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CertificateBasedAuthConfiguration put(@Nonnull final CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newCertificateBasedAuthConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CertificateBasedAuthConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CertificateBasedAuthConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

