// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.FreeBusyStatus;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule Item.
 */
public class ScheduleItem implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The End.
     * The date, time, and time zone that the corresponding event ends.
     */
    @SerializedName(value = "end", alternate = {"End"})
    @Expose
	@Nullable
    public DateTimeTimeZone end;

    /**
     * The Is Private.
     * The sensitivity of the corresponding event. True if the event is marked private, false otherwise. Optional.
     */
    @SerializedName(value = "isPrivate", alternate = {"IsPrivate"})
    @Expose
	@Nullable
    public Boolean isPrivate;

    /**
     * The Location.
     * The location where the corresponding event is held or attended from. Optional.
     */
    @SerializedName(value = "location", alternate = {"Location"})
    @Expose
	@Nullable
    public String location;

    /**
     * The Start.
     * The date, time, and time zone that the corresponding event starts.
     */
    @SerializedName(value = "start", alternate = {"Start"})
    @Expose
	@Nullable
    public DateTimeTimeZone start;

    /**
     * The Status.
     * The availability status of the user or resource during the corresponding event. The possible values are: free, tentative, busy, oof, workingElsewhere, unknown.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public FreeBusyStatus status;

    /**
     * The Subject.
     * The corresponding event's subject line. Optional.
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public String subject;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
