// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Prompt;
import com.microsoft.graph.models.PlayPromptOperation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Play Prompt Parameter Set.
 */
public class CallPlayPromptParameterSet {
    /**
     * The prompts.
     * 
     */
    @SerializedName(value = "prompts", alternate = {"Prompts"})
    @Expose
	@Nullable
    public java.util.List<Prompt> prompts;

    /**
     * The client Context.
     * 
     */
    @SerializedName(value = "clientContext", alternate = {"ClientContext"})
    @Expose
	@Nullable
    public String clientContext;


    /**
     * Instiaciates a new CallPlayPromptParameterSet
     */
    public CallPlayPromptParameterSet() {}
    /**
     * Instiaciates a new CallPlayPromptParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected CallPlayPromptParameterSet(@Nonnull final CallPlayPromptParameterSetBuilder builder) {
        this.prompts = builder.prompts;
        this.clientContext = builder.clientContext;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static CallPlayPromptParameterSetBuilder newBuilder() {
        return new CallPlayPromptParameterSetBuilder();
    }
    /**
     * Fluent builder for the CallPlayPromptParameterSet
     */
    public static final class CallPlayPromptParameterSetBuilder {
        /**
         * The prompts parameter value
         */
        @Nullable
        protected java.util.List<Prompt> prompts;
        /**
         * Sets the Prompts
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallPlayPromptParameterSetBuilder withPrompts(@Nullable final java.util.List<Prompt> val) {
            this.prompts = val;
            return this;
        }
        /**
         * The clientContext parameter value
         */
        @Nullable
        protected String clientContext;
        /**
         * Sets the ClientContext
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public CallPlayPromptParameterSetBuilder withClientContext(@Nullable final String val) {
            this.clientContext = val;
            return this;
        }
        /**
         * Instanciates a new CallPlayPromptParameterSetBuilder
         */
        @Nullable
        protected CallPlayPromptParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public CallPlayPromptParameterSet build() {
            return new CallPlayPromptParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.prompts != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("prompts", prompts));
        }
        if(this.clientContext != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("clientContext", clientContext));
        }
        return result;
    }
}
