// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceManagementTroubleshootingEvent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Troubleshooting Event Request.
 */
public class DeviceManagementTroubleshootingEventRequest extends BaseRequest<DeviceManagementTroubleshootingEvent> {
	
    /**
     * The request for the DeviceManagementTroubleshootingEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public DeviceManagementTroubleshootingEventRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends DeviceManagementTroubleshootingEvent> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the DeviceManagementTroubleshootingEvent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceManagementTroubleshootingEventRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementTroubleshootingEvent.class);
    }

    /**
     * Gets the DeviceManagementTroubleshootingEvent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementTroubleshootingEvent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceManagementTroubleshootingEvent from the service
     *
     * @return the DeviceManagementTroubleshootingEvent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementTroubleshootingEvent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementTroubleshootingEvent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceManagementTroubleshootingEvent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceManagementTroubleshootingEvent with a source
     *
     * @param sourceDeviceManagementTroubleshootingEvent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementTroubleshootingEvent> patchAsync(@Nonnull final DeviceManagementTroubleshootingEvent sourceDeviceManagementTroubleshootingEvent) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceManagementTroubleshootingEvent);
    }

    /**
     * Patches this DeviceManagementTroubleshootingEvent with a source
     *
     * @param sourceDeviceManagementTroubleshootingEvent the source object with updates
     * @return the updated DeviceManagementTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementTroubleshootingEvent patch(@Nonnull final DeviceManagementTroubleshootingEvent sourceDeviceManagementTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceManagementTroubleshootingEvent);
    }

    /**
     * Creates a DeviceManagementTroubleshootingEvent with a new object
     *
     * @param newDeviceManagementTroubleshootingEvent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementTroubleshootingEvent> postAsync(@Nonnull final DeviceManagementTroubleshootingEvent newDeviceManagementTroubleshootingEvent) {
        return sendAsync(HttpMethod.POST, newDeviceManagementTroubleshootingEvent);
    }

    /**
     * Creates a DeviceManagementTroubleshootingEvent with a new object
     *
     * @param newDeviceManagementTroubleshootingEvent the new object to create
     * @return the created DeviceManagementTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementTroubleshootingEvent post(@Nonnull final DeviceManagementTroubleshootingEvent newDeviceManagementTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.POST, newDeviceManagementTroubleshootingEvent);
    }

    /**
     * Creates a DeviceManagementTroubleshootingEvent with a new object
     *
     * @param newDeviceManagementTroubleshootingEvent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceManagementTroubleshootingEvent> putAsync(@Nonnull final DeviceManagementTroubleshootingEvent newDeviceManagementTroubleshootingEvent) {
        return sendAsync(HttpMethod.PUT, newDeviceManagementTroubleshootingEvent);
    }

    /**
     * Creates a DeviceManagementTroubleshootingEvent with a new object
     *
     * @param newDeviceManagementTroubleshootingEvent the object to create/update
     * @return the created DeviceManagementTroubleshootingEvent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceManagementTroubleshootingEvent put(@Nonnull final DeviceManagementTroubleshootingEvent newDeviceManagementTroubleshootingEvent) throws ClientException {
        return send(HttpMethod.PUT, newDeviceManagementTroubleshootingEvent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementTroubleshootingEventRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceManagementTroubleshootingEventRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

