// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookNamedItem;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Named Item Add Parameter Set.
 */
public class WorkbookNamedItemAddParameterSet {
    /**
     * The name.
     * 
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The reference.
     * 
     */
    @SerializedName(value = "reference", alternate = {"Reference"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement reference;

    /**
     * The comment.
     * 
     */
    @SerializedName(value = "comment", alternate = {"Comment"})
    @Expose
	@Nullable
    public String comment;


    /**
     * Instiaciates a new WorkbookNamedItemAddParameterSet
     */
    public WorkbookNamedItemAddParameterSet() {}
    /**
     * Instiaciates a new WorkbookNamedItemAddParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookNamedItemAddParameterSet(@Nonnull final WorkbookNamedItemAddParameterSetBuilder builder) {
        this.name = builder.name;
        this.reference = builder.reference;
        this.comment = builder.comment;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookNamedItemAddParameterSetBuilder newBuilder() {
        return new WorkbookNamedItemAddParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookNamedItemAddParameterSet
     */
    public static final class WorkbookNamedItemAddParameterSetBuilder {
        /**
         * The name parameter value
         */
        @Nullable
        protected String name;
        /**
         * Sets the Name
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookNamedItemAddParameterSetBuilder withName(@Nullable final String val) {
            this.name = val;
            return this;
        }
        /**
         * The reference parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement reference;
        /**
         * Sets the Reference
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookNamedItemAddParameterSetBuilder withReference(@Nullable final com.google.gson.JsonElement val) {
            this.reference = val;
            return this;
        }
        /**
         * The comment parameter value
         */
        @Nullable
        protected String comment;
        /**
         * Sets the Comment
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookNamedItemAddParameterSetBuilder withComment(@Nullable final String val) {
            this.comment = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookNamedItemAddParameterSetBuilder
         */
        @Nullable
        protected WorkbookNamedItemAddParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookNamedItemAddParameterSet build() {
            return new WorkbookNamedItemAddParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.name != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("name", name));
        }
        if(this.reference != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("reference", reference));
        }
        if(this.comment != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("comment", comment));
        }
        return result;
    }
}
