// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.RecentNotebook;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Get Recent Notebooks Parameter Set.
 */
public class NotebookGetRecentNotebooksParameterSet {
    /**
     * The include Personal Notebooks.
     * 
     */
    @SerializedName(value = "includePersonalNotebooks", alternate = {"IncludePersonalNotebooks"})
    @Expose
	@Nullable
    public Boolean includePersonalNotebooks;


    /**
     * Instiaciates a new NotebookGetRecentNotebooksParameterSet
     */
    public NotebookGetRecentNotebooksParameterSet() {}
    /**
     * Instiaciates a new NotebookGetRecentNotebooksParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected NotebookGetRecentNotebooksParameterSet(@Nonnull final NotebookGetRecentNotebooksParameterSetBuilder builder) {
        this.includePersonalNotebooks = builder.includePersonalNotebooks;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static NotebookGetRecentNotebooksParameterSetBuilder newBuilder() {
        return new NotebookGetRecentNotebooksParameterSetBuilder();
    }
    /**
     * Fluent builder for the NotebookGetRecentNotebooksParameterSet
     */
    public static final class NotebookGetRecentNotebooksParameterSetBuilder {
        /**
         * The includePersonalNotebooks parameter value
         */
        @Nullable
        protected Boolean includePersonalNotebooks;
        /**
         * Sets the IncludePersonalNotebooks
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public NotebookGetRecentNotebooksParameterSetBuilder withIncludePersonalNotebooks(@Nullable final Boolean val) {
            this.includePersonalNotebooks = val;
            return this;
        }
        /**
         * Instanciates a new NotebookGetRecentNotebooksParameterSetBuilder
         */
        @Nullable
        protected NotebookGetRecentNotebooksParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public NotebookGetRecentNotebooksParameterSet build() {
            return new NotebookGetRecentNotebooksParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.includePersonalNotebooks != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("includePersonalNotebooks", includePersonalNotebooks));
        }
        return result;
    }
}
