// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceComplianceScheduledActionForRule;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Policy Schedule Actions For Rules Parameter Set.
 */
public class DeviceCompliancePolicyScheduleActionsForRulesParameterSet {
    /**
     * The device Compliance Scheduled Action For Rules.
     * 
     */
    @SerializedName(value = "deviceComplianceScheduledActionForRules", alternate = {"DeviceComplianceScheduledActionForRules"})
    @Expose
	@Nullable
    public java.util.List<DeviceComplianceScheduledActionForRule> deviceComplianceScheduledActionForRules;


    /**
     * Instiaciates a new DeviceCompliancePolicyScheduleActionsForRulesParameterSet
     */
    public DeviceCompliancePolicyScheduleActionsForRulesParameterSet() {}
    /**
     * Instiaciates a new DeviceCompliancePolicyScheduleActionsForRulesParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DeviceCompliancePolicyScheduleActionsForRulesParameterSet(@Nonnull final DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder builder) {
        this.deviceComplianceScheduledActionForRules = builder.deviceComplianceScheduledActionForRules;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder newBuilder() {
        return new DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder();
    }
    /**
     * Fluent builder for the DeviceCompliancePolicyScheduleActionsForRulesParameterSet
     */
    public static final class DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder {
        /**
         * The deviceComplianceScheduledActionForRules parameter value
         */
        @Nullable
        protected java.util.List<DeviceComplianceScheduledActionForRule> deviceComplianceScheduledActionForRules;
        /**
         * Sets the DeviceComplianceScheduledActionForRules
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder withDeviceComplianceScheduledActionForRules(@Nullable final java.util.List<DeviceComplianceScheduledActionForRule> val) {
            this.deviceComplianceScheduledActionForRules = val;
            return this;
        }
        /**
         * Instanciates a new DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder
         */
        @Nullable
        protected DeviceCompliancePolicyScheduleActionsForRulesParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DeviceCompliancePolicyScheduleActionsForRulesParameterSet build() {
            return new DeviceCompliancePolicyScheduleActionsForRulesParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.deviceComplianceScheduledActionForRules != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("deviceComplianceScheduledActionForRules", deviceComplianceScheduledActionForRules));
        }
        return result;
    }
}
