// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.BookingQuestionAnswer;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.BookingCustomerInformationBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Customer Information.
 */
public class BookingCustomerInformation extends BookingCustomerInformationBase implements IJsonBackedObject {


    /**
     * The Customer Id.
     * The ID of the bookingCustomer for this appointment. If no ID is specified when an appointment is created, then a new bookingCustomer object is created. Once set, you should consider the customerId immutable.
     */
    @SerializedName(value = "customerId", alternate = {"CustomerId"})
    @Expose
	@Nullable
    public String customerId;

    /**
     * The Custom Question Answers.
     * It consists of the list of custom questions and answers given by the customer as part of the appointment.
     */
    @SerializedName(value = "customQuestionAnswers", alternate = {"CustomQuestionAnswers"})
    @Expose
	@Nullable
    public java.util.List<BookingQuestionAnswer> customQuestionAnswers;

    /**
     * The Email Address.
     * The SMTP address of the bookingCustomer who is booking the appointment.
     */
    @SerializedName(value = "emailAddress", alternate = {"EmailAddress"})
    @Expose
	@Nullable
    public String emailAddress;

    /**
     * The Location.
     * Represents location information for the bookingCustomer who is booking the appointment.
     */
    @SerializedName(value = "location", alternate = {"Location"})
    @Expose
	@Nullable
    public Location location;

    /**
     * The Name.
     * The customer's name.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Notes.
     * Notes from the customer associated with this appointment. You can get the value only when reading this bookingAppointment by its ID. You can set this property only when initially creating an appointment with a new customer. After that point, the value is computed from the customer represented by the customerId.
     */
    @SerializedName(value = "notes", alternate = {"Notes"})
    @Expose
	@Nullable
    public String notes;

    /**
     * The Phone.
     * The customer's phone number.
     */
    @SerializedName(value = "phone", alternate = {"Phone"})
    @Expose
	@Nullable
    public String phone;

    /**
     * The Time Zone.
     * The time zone of the customer. For a list of possible values, see dateTimeTimeZone.
     */
    @SerializedName(value = "timeZone", alternate = {"TimeZone"})
    @Expose
	@Nullable
    public String timeZone;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
