// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PlannerTask;
import com.microsoft.graph.requests.PlannerAssignedToTaskBoardTaskFormatRequestBuilder;
import com.microsoft.graph.requests.PlannerBucketTaskBoardTaskFormatRequestBuilder;
import com.microsoft.graph.requests.PlannerTaskDetailsRequestBuilder;
import com.microsoft.graph.requests.PlannerProgressTaskBoardTaskFormatRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Planner Task Request.
 */
public class PlannerTaskRequest extends BaseRequest<PlannerTask> {
	
    /**
     * The request for the PlannerTask
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PlannerTaskRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PlannerTask.class);
    }

    /**
     * Gets the PlannerTask from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerTask> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PlannerTask from the service
     *
     * @return the PlannerTask from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerTask get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerTask> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PlannerTask delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PlannerTask with a source
     *
     * @param sourcePlannerTask the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerTask> patchAsync(@Nonnull final PlannerTask sourcePlannerTask) {
        return sendAsync(HttpMethod.PATCH, sourcePlannerTask);
    }

    /**
     * Patches this PlannerTask with a source
     *
     * @param sourcePlannerTask the source object with updates
     * @return the updated PlannerTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerTask patch(@Nonnull final PlannerTask sourcePlannerTask) throws ClientException {
        return send(HttpMethod.PATCH, sourcePlannerTask);
    }

    /**
     * Creates a PlannerTask with a new object
     *
     * @param newPlannerTask the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerTask> postAsync(@Nonnull final PlannerTask newPlannerTask) {
        return sendAsync(HttpMethod.POST, newPlannerTask);
    }

    /**
     * Creates a PlannerTask with a new object
     *
     * @param newPlannerTask the new object to create
     * @return the created PlannerTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerTask post(@Nonnull final PlannerTask newPlannerTask) throws ClientException {
        return send(HttpMethod.POST, newPlannerTask);
    }

    /**
     * Creates a PlannerTask with a new object
     *
     * @param newPlannerTask the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PlannerTask> putAsync(@Nonnull final PlannerTask newPlannerTask) {
        return sendAsync(HttpMethod.PUT, newPlannerTask);
    }

    /**
     * Creates a PlannerTask with a new object
     *
     * @param newPlannerTask the object to create/update
     * @return the created PlannerTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PlannerTask put(@Nonnull final PlannerTask newPlannerTask) throws ClientException {
        return send(HttpMethod.PUT, newPlannerTask);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PlannerTaskRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PlannerTaskRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

