/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ServicePrincipal;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServicePrincipalRequest
extends BaseRequest<ServicePrincipal> {
    public ServicePrincipalRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipal.class);
    }

    @Nonnull
    public CompletableFuture<ServicePrincipal> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ServicePrincipal get() throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ServicePrincipal> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ServicePrincipal delete() throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ServicePrincipal> patchAsync(@Nonnull ServicePrincipal sourceServicePrincipal) {
        return this.sendAsync(HttpMethod.PATCH, sourceServicePrincipal);
    }

    @Nullable
    public ServicePrincipal patch(@Nonnull ServicePrincipal sourceServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.PATCH, sourceServicePrincipal);
    }

    @Nonnull
    public CompletableFuture<ServicePrincipal> postAsync(@Nonnull ServicePrincipal newServicePrincipal) {
        return this.sendAsync(HttpMethod.POST, newServicePrincipal);
    }

    @Nullable
    public ServicePrincipal post(@Nonnull ServicePrincipal newServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.POST, newServicePrincipal);
    }

    @Nonnull
    public CompletableFuture<ServicePrincipal> putAsync(@Nonnull ServicePrincipal newServicePrincipal) {
        return this.sendAsync(HttpMethod.PUT, newServicePrincipal);
    }

    @Nullable
    public ServicePrincipal put(@Nonnull ServicePrincipal newServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.PUT, newServicePrincipal);
    }

    @Nonnull
    public ServicePrincipalRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ServicePrincipalRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

