/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.CloudCommunications;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CloudCommunicationsRequest
extends BaseRequest<CloudCommunications> {
    public CloudCommunicationsRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CloudCommunications.class);
    }

    @Nonnull
    public CompletableFuture<CloudCommunications> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public CloudCommunications get() throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<CloudCommunications> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public CloudCommunications delete() throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<CloudCommunications> patchAsync(@Nonnull CloudCommunications sourceCloudCommunications) {
        return this.sendAsync(HttpMethod.PATCH, sourceCloudCommunications);
    }

    @Nullable
    public CloudCommunications patch(@Nonnull CloudCommunications sourceCloudCommunications) throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.PATCH, sourceCloudCommunications);
    }

    @Nonnull
    public CompletableFuture<CloudCommunications> postAsync(@Nonnull CloudCommunications newCloudCommunications) {
        return this.sendAsync(HttpMethod.POST, newCloudCommunications);
    }

    @Nullable
    public CloudCommunications post(@Nonnull CloudCommunications newCloudCommunications) throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.POST, newCloudCommunications);
    }

    @Nonnull
    public CompletableFuture<CloudCommunications> putAsync(@Nonnull CloudCommunications newCloudCommunications) {
        return this.sendAsync(HttpMethod.PUT, newCloudCommunications);
    }

    @Nullable
    public CloudCommunications put(@Nonnull CloudCommunications newCloudCommunications) throws ClientException {
        return (CloudCommunications)this.send(HttpMethod.PUT, newCloudCommunications);
    }

    @Nonnull
    public CloudCommunicationsRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CloudCommunicationsRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

