// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Enablement;
import com.microsoft.graph.models.WindowsHelloForBusinessPinUsage;
import com.microsoft.graph.models.DeviceEnrollmentConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Enrollment Windows Hello For Business Configuration.
 */
public class DeviceEnrollmentWindowsHelloForBusinessConfiguration extends DeviceEnrollmentConfiguration implements IJsonBackedObject {


    /**
     * The Enhanced Biometrics State.
     * Not yet documented. Possible values are: notConfigured, enabled, disabled.
     */
    @SerializedName(value = "enhancedBiometricsState", alternate = {"EnhancedBiometricsState"})
    @Expose
	@Nullable
    public Enablement enhancedBiometricsState;

    /**
     * The Pin Expiration In Days.
     * Not yet documented
     */
    @SerializedName(value = "pinExpirationInDays", alternate = {"PinExpirationInDays"})
    @Expose
	@Nullable
    public Integer pinExpirationInDays;

    /**
     * The Pin Lowercase Characters Usage.
     * Not yet documented. Possible values are: allowed, required, disallowed.
     */
    @SerializedName(value = "pinLowercaseCharactersUsage", alternate = {"PinLowercaseCharactersUsage"})
    @Expose
	@Nullable
    public WindowsHelloForBusinessPinUsage pinLowercaseCharactersUsage;

    /**
     * The Pin Maximum Length.
     * Not yet documented
     */
    @SerializedName(value = "pinMaximumLength", alternate = {"PinMaximumLength"})
    @Expose
	@Nullable
    public Integer pinMaximumLength;

    /**
     * The Pin Minimum Length.
     * Not yet documented
     */
    @SerializedName(value = "pinMinimumLength", alternate = {"PinMinimumLength"})
    @Expose
	@Nullable
    public Integer pinMinimumLength;

    /**
     * The Pin Previous Block Count.
     * Not yet documented
     */
    @SerializedName(value = "pinPreviousBlockCount", alternate = {"PinPreviousBlockCount"})
    @Expose
	@Nullable
    public Integer pinPreviousBlockCount;

    /**
     * The Pin Special Characters Usage.
     * Not yet documented. Possible values are: allowed, required, disallowed.
     */
    @SerializedName(value = "pinSpecialCharactersUsage", alternate = {"PinSpecialCharactersUsage"})
    @Expose
	@Nullable
    public WindowsHelloForBusinessPinUsage pinSpecialCharactersUsage;

    /**
     * The Pin Uppercase Characters Usage.
     * Not yet documented. Possible values are: allowed, required, disallowed.
     */
    @SerializedName(value = "pinUppercaseCharactersUsage", alternate = {"PinUppercaseCharactersUsage"})
    @Expose
	@Nullable
    public WindowsHelloForBusinessPinUsage pinUppercaseCharactersUsage;

    /**
     * The Remote Passport Enabled.
     * Not yet documented
     */
    @SerializedName(value = "remotePassportEnabled", alternate = {"RemotePassportEnabled"})
    @Expose
	@Nullable
    public Boolean remotePassportEnabled;

    /**
     * The Security Device Required.
     * Not yet documented
     */
    @SerializedName(value = "securityDeviceRequired", alternate = {"SecurityDeviceRequired"})
    @Expose
	@Nullable
    public Boolean securityDeviceRequired;

    /**
     * The State.
     * Not yet documented. Possible values are: notConfigured, enabled, disabled.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public Enablement state;

    /**
     * The Unlock With Biometrics Enabled.
     * Not yet documented
     */
    @SerializedName(value = "unlockWithBiometricsEnabled", alternate = {"UnlockWithBiometricsEnabled"})
    @Expose
	@Nullable
    public Boolean unlockWithBiometricsEnabled;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
