// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AppListItem;
import com.microsoft.graph.models.AppListType;
import com.microsoft.graph.models.RatingAppsType;
import com.microsoft.graph.models.MediaContentRatingAustralia;
import com.microsoft.graph.models.MediaContentRatingCanada;
import com.microsoft.graph.models.MediaContentRatingFrance;
import com.microsoft.graph.models.MediaContentRatingGermany;
import com.microsoft.graph.models.MediaContentRatingIreland;
import com.microsoft.graph.models.MediaContentRatingJapan;
import com.microsoft.graph.models.MediaContentRatingNewZealand;
import com.microsoft.graph.models.MediaContentRatingUnitedKingdom;
import com.microsoft.graph.models.MediaContentRatingUnitedStates;
import com.microsoft.graph.models.IosNetworkUsageRule;
import com.microsoft.graph.models.RequiredPasswordType;
import com.microsoft.graph.models.WebBrowserCookieSettings;
import com.microsoft.graph.models.DeviceConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios General Device Configuration.
 */
public class IosGeneralDeviceConfiguration extends DeviceConfiguration implements IJsonBackedObject {


    /**
     * The Account Block Modification.
     * Indicates whether or not to allow account modification when the device is in supervised mode.
     */
    @SerializedName(value = "accountBlockModification", alternate = {"AccountBlockModification"})
    @Expose
	@Nullable
    public Boolean accountBlockModification;

    /**
     * The Activation Lock Allow When Supervised.
     * Indicates whether or not to allow activation lock when the device is in the supervised mode.
     */
    @SerializedName(value = "activationLockAllowWhenSupervised", alternate = {"ActivationLockAllowWhenSupervised"})
    @Expose
	@Nullable
    public Boolean activationLockAllowWhenSupervised;

    /**
     * The Air Drop Blocked.
     * Indicates whether or not to allow AirDrop when the device is in supervised mode.
     */
    @SerializedName(value = "airDropBlocked", alternate = {"AirDropBlocked"})
    @Expose
	@Nullable
    public Boolean airDropBlocked;

    /**
     * The Air Drop Force Unmanaged Drop Target.
     * Indicates whether or not to cause AirDrop to be considered an unmanaged drop target (iOS 9.0 and later).
     */
    @SerializedName(value = "airDropForceUnmanagedDropTarget", alternate = {"AirDropForceUnmanagedDropTarget"})
    @Expose
	@Nullable
    public Boolean airDropForceUnmanagedDropTarget;

    /**
     * The Air Play Force Pairing Password For Outgoing Requests.
     * Indicates whether or not to enforce all devices receiving AirPlay requests from this device to use a pairing password.
     */
    @SerializedName(value = "airPlayForcePairingPasswordForOutgoingRequests", alternate = {"AirPlayForcePairingPasswordForOutgoingRequests"})
    @Expose
	@Nullable
    public Boolean airPlayForcePairingPasswordForOutgoingRequests;

    /**
     * The Apple News Blocked.
     * Indicates whether or not to block the user from using News when the device is in supervised mode (iOS 9.0 and later).
     */
    @SerializedName(value = "appleNewsBlocked", alternate = {"AppleNewsBlocked"})
    @Expose
	@Nullable
    public Boolean appleNewsBlocked;

    /**
     * The Apple Watch Block Pairing.
     * Indicates whether or not to allow Apple Watch pairing when the device is in supervised mode (iOS 9.0 and later).
     */
    @SerializedName(value = "appleWatchBlockPairing", alternate = {"AppleWatchBlockPairing"})
    @Expose
	@Nullable
    public Boolean appleWatchBlockPairing;

    /**
     * The Apple Watch Force Wrist Detection.
     * Indicates whether or not to force a paired Apple Watch to use Wrist Detection (iOS 8.2 and later).
     */
    @SerializedName(value = "appleWatchForceWristDetection", alternate = {"AppleWatchForceWristDetection"})
    @Expose
	@Nullable
    public Boolean appleWatchForceWristDetection;

    /**
     * The Apps Single App Mode List.
     * Gets or sets the list of iOS apps allowed to autonomously enter Single App Mode. Supervised only. iOS 7.0 and later. This collection can contain a maximum of 500 elements.
     */
    @SerializedName(value = "appsSingleAppModeList", alternate = {"AppsSingleAppModeList"})
    @Expose
	@Nullable
    public java.util.List<AppListItem> appsSingleAppModeList;

    /**
     * The App Store Block Automatic Downloads.
     * Indicates whether or not to block the automatic downloading of apps purchased on other devices when the device is in supervised mode (iOS 9.0 and later).
     */
    @SerializedName(value = "appStoreBlockAutomaticDownloads", alternate = {"AppStoreBlockAutomaticDownloads"})
    @Expose
	@Nullable
    public Boolean appStoreBlockAutomaticDownloads;

    /**
     * The App Store Blocked.
     * Indicates whether or not to block the user from using the App Store. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "appStoreBlocked", alternate = {"AppStoreBlocked"})
    @Expose
	@Nullable
    public Boolean appStoreBlocked;

    /**
     * The App Store Block In App Purchases.
     * Indicates whether or not to block the user from making in app purchases.
     */
    @SerializedName(value = "appStoreBlockInAppPurchases", alternate = {"AppStoreBlockInAppPurchases"})
    @Expose
	@Nullable
    public Boolean appStoreBlockInAppPurchases;

    /**
     * The App Store Block UIApp Installation.
     * Indicates whether or not to block the App Store app, not restricting installation through Host apps. Applies to supervised mode only (iOS 9.0 and later).
     */
    @SerializedName(value = "appStoreBlockUIAppInstallation", alternate = {"AppStoreBlockUIAppInstallation"})
    @Expose
	@Nullable
    public Boolean appStoreBlockUIAppInstallation;

    /**
     * The App Store Require Password.
     * Indicates whether or not to require a password when using the app store.
     */
    @SerializedName(value = "appStoreRequirePassword", alternate = {"AppStoreRequirePassword"})
    @Expose
	@Nullable
    public Boolean appStoreRequirePassword;

    /**
     * The Apps Visibility List.
     * List of apps in the visibility list (either visible/launchable apps list or hidden/unlaunchable apps list, controlled by AppsVisibilityListType) (iOS 9.3 and later). This collection can contain a maximum of 10000 elements.
     */
    @SerializedName(value = "appsVisibilityList", alternate = {"AppsVisibilityList"})
    @Expose
	@Nullable
    public java.util.List<AppListItem> appsVisibilityList;

    /**
     * The Apps Visibility List Type.
     * Type of list that is in the AppsVisibilityList. Possible values are: none, appsInListCompliant, appsNotInListCompliant.
     */
    @SerializedName(value = "appsVisibilityListType", alternate = {"AppsVisibilityListType"})
    @Expose
	@Nullable
    public AppListType appsVisibilityListType;

    /**
     * The Bluetooth Block Modification.
     * Indicates whether or not to allow modification of Bluetooth settings when the device is in supervised mode (iOS 10.0 and later).
     */
    @SerializedName(value = "bluetoothBlockModification", alternate = {"BluetoothBlockModification"})
    @Expose
	@Nullable
    public Boolean bluetoothBlockModification;

    /**
     * The Camera Blocked.
     * Indicates whether or not to block the user from accessing the camera of the device. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "cameraBlocked", alternate = {"CameraBlocked"})
    @Expose
	@Nullable
    public Boolean cameraBlocked;

    /**
     * The Cellular Block Data Roaming.
     * Indicates whether or not to block data roaming.
     */
    @SerializedName(value = "cellularBlockDataRoaming", alternate = {"CellularBlockDataRoaming"})
    @Expose
	@Nullable
    public Boolean cellularBlockDataRoaming;

    /**
     * The Cellular Block Global Background Fetch While Roaming.
     * Indicates whether or not to block global background fetch while roaming.
     */
    @SerializedName(value = "cellularBlockGlobalBackgroundFetchWhileRoaming", alternate = {"CellularBlockGlobalBackgroundFetchWhileRoaming"})
    @Expose
	@Nullable
    public Boolean cellularBlockGlobalBackgroundFetchWhileRoaming;

    /**
     * The Cellular Block Per App Data Modification.
     * Indicates whether or not to allow changes to cellular app data usage settings when the device is in supervised mode.
     */
    @SerializedName(value = "cellularBlockPerAppDataModification", alternate = {"CellularBlockPerAppDataModification"})
    @Expose
	@Nullable
    public Boolean cellularBlockPerAppDataModification;

    /**
     * The Cellular Block Personal Hotspot.
     * Indicates whether or not to block Personal Hotspot.
     */
    @SerializedName(value = "cellularBlockPersonalHotspot", alternate = {"CellularBlockPersonalHotspot"})
    @Expose
	@Nullable
    public Boolean cellularBlockPersonalHotspot;

    /**
     * The Cellular Block Voice Roaming.
     * Indicates whether or not to block voice roaming.
     */
    @SerializedName(value = "cellularBlockVoiceRoaming", alternate = {"CellularBlockVoiceRoaming"})
    @Expose
	@Nullable
    public Boolean cellularBlockVoiceRoaming;

    /**
     * The Certificates Block Untrusted Tls Certificates.
     * Indicates whether or not to block untrusted TLS certificates.
     */
    @SerializedName(value = "certificatesBlockUntrustedTlsCertificates", alternate = {"CertificatesBlockUntrustedTlsCertificates"})
    @Expose
	@Nullable
    public Boolean certificatesBlockUntrustedTlsCertificates;

    /**
     * The Classroom App Block Remote Screen Observation.
     * Indicates whether or not to allow remote screen observation by Classroom app when the device is in supervised mode (iOS 9.3 and later).
     */
    @SerializedName(value = "classroomAppBlockRemoteScreenObservation", alternate = {"ClassroomAppBlockRemoteScreenObservation"})
    @Expose
	@Nullable
    public Boolean classroomAppBlockRemoteScreenObservation;

    /**
     * The Classroom App Force Unprompted Screen Observation.
     * Indicates whether or not to automatically give permission to the teacher of a managed course on the Classroom app to view a student's screen without prompting when the device is in supervised mode.
     */
    @SerializedName(value = "classroomAppForceUnpromptedScreenObservation", alternate = {"ClassroomAppForceUnpromptedScreenObservation"})
    @Expose
	@Nullable
    public Boolean classroomAppForceUnpromptedScreenObservation;

    /**
     * The Compliant App List Type.
     * List that is in the AppComplianceList. Possible values are: none, appsInListCompliant, appsNotInListCompliant.
     */
    @SerializedName(value = "compliantAppListType", alternate = {"CompliantAppListType"})
    @Expose
	@Nullable
    public AppListType compliantAppListType;

    /**
     * The Compliant Apps List.
     * List of apps in the compliance (either allow list or block list, controlled by CompliantAppListType). This collection can contain a maximum of 10000 elements.
     */
    @SerializedName(value = "compliantAppsList", alternate = {"CompliantAppsList"})
    @Expose
	@Nullable
    public java.util.List<AppListItem> compliantAppsList;

    /**
     * The Configuration Profile Block Changes.
     * Indicates whether or not to block the user from installing configuration profiles and certificates interactively when the device is in supervised mode.
     */
    @SerializedName(value = "configurationProfileBlockChanges", alternate = {"ConfigurationProfileBlockChanges"})
    @Expose
	@Nullable
    public Boolean configurationProfileBlockChanges;

    /**
     * The Definition Lookup Blocked.
     * Indicates whether or not to block definition lookup when the device is in supervised mode (iOS 8.1.3 and later ).
     */
    @SerializedName(value = "definitionLookupBlocked", alternate = {"DefinitionLookupBlocked"})
    @Expose
	@Nullable
    public Boolean definitionLookupBlocked;

    /**
     * The Device Block Enable Restrictions.
     * Indicates whether or not to allow the user to enables restrictions in the device settings when the device is in supervised mode.
     */
    @SerializedName(value = "deviceBlockEnableRestrictions", alternate = {"DeviceBlockEnableRestrictions"})
    @Expose
	@Nullable
    public Boolean deviceBlockEnableRestrictions;

    /**
     * The Device Block Erase Content And Settings.
     * Indicates whether or not to allow the use of the 'Erase all content and settings' option on the device when the device is in supervised mode.
     */
    @SerializedName(value = "deviceBlockEraseContentAndSettings", alternate = {"DeviceBlockEraseContentAndSettings"})
    @Expose
	@Nullable
    public Boolean deviceBlockEraseContentAndSettings;

    /**
     * The Device Block Name Modification.
     * Indicates whether or not to allow device name modification when the device is in supervised mode (iOS 9.0 and later).
     */
    @SerializedName(value = "deviceBlockNameModification", alternate = {"DeviceBlockNameModification"})
    @Expose
	@Nullable
    public Boolean deviceBlockNameModification;

    /**
     * The Diagnostic Data Block Submission.
     * Indicates whether or not to block diagnostic data submission.
     */
    @SerializedName(value = "diagnosticDataBlockSubmission", alternate = {"DiagnosticDataBlockSubmission"})
    @Expose
	@Nullable
    public Boolean diagnosticDataBlockSubmission;

    /**
     * The Diagnostic Data Block Submission Modification.
     * Indicates whether or not to allow diagnostics submission settings modification when the device is in supervised mode (iOS 9.3.2 and later).
     */
    @SerializedName(value = "diagnosticDataBlockSubmissionModification", alternate = {"DiagnosticDataBlockSubmissionModification"})
    @Expose
	@Nullable
    public Boolean diagnosticDataBlockSubmissionModification;

    /**
     * The Documents Block Managed Documents In Unmanaged Apps.
     * Indicates whether or not to block the user from viewing managed documents in unmanaged apps.
     */
    @SerializedName(value = "documentsBlockManagedDocumentsInUnmanagedApps", alternate = {"DocumentsBlockManagedDocumentsInUnmanagedApps"})
    @Expose
	@Nullable
    public Boolean documentsBlockManagedDocumentsInUnmanagedApps;

    /**
     * The Documents Block Unmanaged Documents In Managed Apps.
     * Indicates whether or not to block the user from viewing unmanaged documents in managed apps.
     */
    @SerializedName(value = "documentsBlockUnmanagedDocumentsInManagedApps", alternate = {"DocumentsBlockUnmanagedDocumentsInManagedApps"})
    @Expose
	@Nullable
    public Boolean documentsBlockUnmanagedDocumentsInManagedApps;

    /**
     * The Email In Domain Suffixes.
     * An email address lacking a suffix that matches any of these strings will be considered out-of-domain.
     */
    @SerializedName(value = "emailInDomainSuffixes", alternate = {"EmailInDomainSuffixes"})
    @Expose
	@Nullable
    public java.util.List<String> emailInDomainSuffixes;

    /**
     * The Enterprise App Block Trust.
     * Indicates whether or not to block the user from trusting an enterprise app.
     */
    @SerializedName(value = "enterpriseAppBlockTrust", alternate = {"EnterpriseAppBlockTrust"})
    @Expose
	@Nullable
    public Boolean enterpriseAppBlockTrust;

    /**
     * The Enterprise App Block Trust Modification.
     * [Deprecated] Configuring this setting and setting the value to 'true' has no effect on the device.
     */
    @SerializedName(value = "enterpriseAppBlockTrustModification", alternate = {"EnterpriseAppBlockTrustModification"})
    @Expose
	@Nullable
    public Boolean enterpriseAppBlockTrustModification;

    /**
     * The Face Time Blocked.
     * Indicates whether or not to block the user from using FaceTime. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "faceTimeBlocked", alternate = {"FaceTimeBlocked"})
    @Expose
	@Nullable
    public Boolean faceTimeBlocked;

    /**
     * The Find My Friends Blocked.
     * Indicates whether or not to block changes to Find My Friends when the device is in supervised mode.
     */
    @SerializedName(value = "findMyFriendsBlocked", alternate = {"FindMyFriendsBlocked"})
    @Expose
	@Nullable
    public Boolean findMyFriendsBlocked;

    /**
     * The Game Center Blocked.
     * Indicates whether or not to block the user from using Game Center when the device is in supervised mode.
     */
    @SerializedName(value = "gameCenterBlocked", alternate = {"GameCenterBlocked"})
    @Expose
	@Nullable
    public Boolean gameCenterBlocked;

    /**
     * The Gaming Block Game Center Friends.
     * Indicates whether or not to block the user from having friends in Game Center. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "gamingBlockGameCenterFriends", alternate = {"GamingBlockGameCenterFriends"})
    @Expose
	@Nullable
    public Boolean gamingBlockGameCenterFriends;

    /**
     * The Gaming Block Multiplayer.
     * Indicates whether or not to block the user from using multiplayer gaming. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "gamingBlockMultiplayer", alternate = {"GamingBlockMultiplayer"})
    @Expose
	@Nullable
    public Boolean gamingBlockMultiplayer;

    /**
     * The Host Pairing Blocked.
     * indicates whether or not to allow host pairing to control the devices an iOS device can pair with when the iOS device is in supervised mode.
     */
    @SerializedName(value = "hostPairingBlocked", alternate = {"HostPairingBlocked"})
    @Expose
	@Nullable
    public Boolean hostPairingBlocked;

    /**
     * The IBooks Store Blocked.
     * Indicates whether or not to block the user from using the iBooks Store when the device is in supervised mode.
     */
    @SerializedName(value = "iBooksStoreBlocked", alternate = {"IBooksStoreBlocked"})
    @Expose
	@Nullable
    public Boolean iBooksStoreBlocked;

    /**
     * The IBooks Store Block Erotica.
     * Indicates whether or not to block the user from downloading media from the iBookstore that has been tagged as erotica.
     */
    @SerializedName(value = "iBooksStoreBlockErotica", alternate = {"IBooksStoreBlockErotica"})
    @Expose
	@Nullable
    public Boolean iBooksStoreBlockErotica;

    /**
     * The ICloud Block Activity Continuation.
     * Indicates whether or not to block the user from continuing work they started on iOS device to another iOS or macOS device.
     */
    @SerializedName(value = "iCloudBlockActivityContinuation", alternate = {"ICloudBlockActivityContinuation"})
    @Expose
	@Nullable
    public Boolean iCloudBlockActivityContinuation;

    /**
     * The ICloud Block Backup.
     * Indicates whether or not to block iCloud backup. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "iCloudBlockBackup", alternate = {"ICloudBlockBackup"})
    @Expose
	@Nullable
    public Boolean iCloudBlockBackup;

    /**
     * The ICloud Block Document Sync.
     * Indicates whether or not to block iCloud document sync. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "iCloudBlockDocumentSync", alternate = {"ICloudBlockDocumentSync"})
    @Expose
	@Nullable
    public Boolean iCloudBlockDocumentSync;

    /**
     * The ICloud Block Managed Apps Sync.
     * Indicates whether or not to block Managed Apps Cloud Sync.
     */
    @SerializedName(value = "iCloudBlockManagedAppsSync", alternate = {"ICloudBlockManagedAppsSync"})
    @Expose
	@Nullable
    public Boolean iCloudBlockManagedAppsSync;

    /**
     * The ICloud Block Photo Library.
     * Indicates whether or not to block iCloud Photo Library.
     */
    @SerializedName(value = "iCloudBlockPhotoLibrary", alternate = {"ICloudBlockPhotoLibrary"})
    @Expose
	@Nullable
    public Boolean iCloudBlockPhotoLibrary;

    /**
     * The ICloud Block Photo Stream Sync.
     * Indicates whether or not to block iCloud Photo Stream Sync.
     */
    @SerializedName(value = "iCloudBlockPhotoStreamSync", alternate = {"ICloudBlockPhotoStreamSync"})
    @Expose
	@Nullable
    public Boolean iCloudBlockPhotoStreamSync;

    /**
     * The ICloud Block Shared Photo Stream.
     * Indicates whether or not to block Shared Photo Stream.
     */
    @SerializedName(value = "iCloudBlockSharedPhotoStream", alternate = {"ICloudBlockSharedPhotoStream"})
    @Expose
	@Nullable
    public Boolean iCloudBlockSharedPhotoStream;

    /**
     * The ICloud Require Encrypted Backup.
     * Indicates whether or not to require backups to iCloud be encrypted.
     */
    @SerializedName(value = "iCloudRequireEncryptedBackup", alternate = {"ICloudRequireEncryptedBackup"})
    @Expose
	@Nullable
    public Boolean iCloudRequireEncryptedBackup;

    /**
     * The ITunes Block Explicit Content.
     * Indicates whether or not to block the user from accessing explicit content in iTunes and the App Store. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "iTunesBlockExplicitContent", alternate = {"ITunesBlockExplicitContent"})
    @Expose
	@Nullable
    public Boolean iTunesBlockExplicitContent;

    /**
     * The ITunes Block Music Service.
     * Indicates whether or not to block Music service and revert Music app to classic mode when the device is in supervised mode (iOS 9.3 and later and macOS 10.12 and later).
     */
    @SerializedName(value = "iTunesBlockMusicService", alternate = {"ITunesBlockMusicService"})
    @Expose
	@Nullable
    public Boolean iTunesBlockMusicService;

    /**
     * The ITunes Block Radio.
     * Indicates whether or not to block the user from using iTunes Radio when the device is in supervised mode (iOS 9.3 and later).
     */
    @SerializedName(value = "iTunesBlockRadio", alternate = {"ITunesBlockRadio"})
    @Expose
	@Nullable
    public Boolean iTunesBlockRadio;

    /**
     * The Keyboard Block Auto Correct.
     * Indicates whether or not to block keyboard auto-correction when the device is in supervised mode (iOS 8.1.3 and later).
     */
    @SerializedName(value = "keyboardBlockAutoCorrect", alternate = {"KeyboardBlockAutoCorrect"})
    @Expose
	@Nullable
    public Boolean keyboardBlockAutoCorrect;

    /**
     * The Keyboard Block Dictation.
     * Indicates whether or not to block the user from using dictation input when the device is in supervised mode.
     */
    @SerializedName(value = "keyboardBlockDictation", alternate = {"KeyboardBlockDictation"})
    @Expose
	@Nullable
    public Boolean keyboardBlockDictation;

    /**
     * The Keyboard Block Predictive.
     * Indicates whether or not to block predictive keyboards when device is in supervised mode (iOS 8.1.3 and later).
     */
    @SerializedName(value = "keyboardBlockPredictive", alternate = {"KeyboardBlockPredictive"})
    @Expose
	@Nullable
    public Boolean keyboardBlockPredictive;

    /**
     * The Keyboard Block Shortcuts.
     * Indicates whether or not to block keyboard shortcuts when the device is in supervised mode (iOS 9.0 and later).
     */
    @SerializedName(value = "keyboardBlockShortcuts", alternate = {"KeyboardBlockShortcuts"})
    @Expose
	@Nullable
    public Boolean keyboardBlockShortcuts;

    /**
     * The Keyboard Block Spell Check.
     * Indicates whether or not to block keyboard spell-checking when the device is in supervised mode (iOS 8.1.3 and later).
     */
    @SerializedName(value = "keyboardBlockSpellCheck", alternate = {"KeyboardBlockSpellCheck"})
    @Expose
	@Nullable
    public Boolean keyboardBlockSpellCheck;

    /**
     * The Kiosk Mode Allow Assistive Speak.
     * Indicates whether or not to allow assistive speak while in kiosk mode.
     */
    @SerializedName(value = "kioskModeAllowAssistiveSpeak", alternate = {"KioskModeAllowAssistiveSpeak"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowAssistiveSpeak;

    /**
     * The Kiosk Mode Allow Assistive Touch Settings.
     * Indicates whether or not to allow access to the Assistive Touch Settings while in kiosk mode.
     */
    @SerializedName(value = "kioskModeAllowAssistiveTouchSettings", alternate = {"KioskModeAllowAssistiveTouchSettings"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowAssistiveTouchSettings;

    /**
     * The Kiosk Mode Allow Auto Lock.
     * Indicates whether or not to allow device auto lock while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockAutoLock instead.
     */
    @SerializedName(value = "kioskModeAllowAutoLock", alternate = {"KioskModeAllowAutoLock"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowAutoLock;

    /**
     * The Kiosk Mode Allow Color Inversion Settings.
     * Indicates whether or not to allow access to the Color Inversion Settings while in kiosk mode.
     */
    @SerializedName(value = "kioskModeAllowColorInversionSettings", alternate = {"KioskModeAllowColorInversionSettings"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowColorInversionSettings;

    /**
     * The Kiosk Mode Allow Ringer Switch.
     * Indicates whether or not to allow use of the ringer switch while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockRingerSwitch instead.
     */
    @SerializedName(value = "kioskModeAllowRingerSwitch", alternate = {"KioskModeAllowRingerSwitch"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowRingerSwitch;

    /**
     * The Kiosk Mode Allow Screen Rotation.
     * Indicates whether or not to allow screen rotation while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockScreenRotation instead.
     */
    @SerializedName(value = "kioskModeAllowScreenRotation", alternate = {"KioskModeAllowScreenRotation"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowScreenRotation;

    /**
     * The Kiosk Mode Allow Sleep Button.
     * Indicates whether or not to allow use of the sleep button while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockSleepButton instead.
     */
    @SerializedName(value = "kioskModeAllowSleepButton", alternate = {"KioskModeAllowSleepButton"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowSleepButton;

    /**
     * The Kiosk Mode Allow Touchscreen.
     * Indicates whether or not to allow use of the touchscreen while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockTouchscreen instead.
     */
    @SerializedName(value = "kioskModeAllowTouchscreen", alternate = {"KioskModeAllowTouchscreen"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowTouchscreen;

    /**
     * The Kiosk Mode Allow Voice Over Settings.
     * Indicates whether or not to allow access to the voice over settings while in kiosk mode.
     */
    @SerializedName(value = "kioskModeAllowVoiceOverSettings", alternate = {"KioskModeAllowVoiceOverSettings"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowVoiceOverSettings;

    /**
     * The Kiosk Mode Allow Volume Buttons.
     * Indicates whether or not to allow use of the volume buttons while in kiosk mode. This property's functionality is redundant with the OS default and is deprecated. Use KioskModeBlockVolumeButtons instead.
     */
    @SerializedName(value = "kioskModeAllowVolumeButtons", alternate = {"KioskModeAllowVolumeButtons"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowVolumeButtons;

    /**
     * The Kiosk Mode Allow Zoom Settings.
     * Indicates whether or not to allow access to the zoom settings while in kiosk mode.
     */
    @SerializedName(value = "kioskModeAllowZoomSettings", alternate = {"KioskModeAllowZoomSettings"})
    @Expose
	@Nullable
    public Boolean kioskModeAllowZoomSettings;

    /**
     * The Kiosk Mode App Store Url.
     * URL in the app store to the app to use for kiosk mode. Use if KioskModeManagedAppId is not known.
     */
    @SerializedName(value = "kioskModeAppStoreUrl", alternate = {"KioskModeAppStoreUrl"})
    @Expose
	@Nullable
    public String kioskModeAppStoreUrl;

    /**
     * The Kiosk Mode Built In App Id.
     * ID for built-in apps to use for kiosk mode. Used when KioskModeManagedAppId and KioskModeAppStoreUrl are not set.
     */
    @SerializedName(value = "kioskModeBuiltInAppId", alternate = {"KioskModeBuiltInAppId"})
    @Expose
	@Nullable
    public String kioskModeBuiltInAppId;

    /**
     * The Kiosk Mode Managed App Id.
     * Managed app id of the app to use for kiosk mode. If KioskModeManagedAppId is specified then KioskModeAppStoreUrl will be ignored.
     */
    @SerializedName(value = "kioskModeManagedAppId", alternate = {"KioskModeManagedAppId"})
    @Expose
	@Nullable
    public String kioskModeManagedAppId;

    /**
     * The Kiosk Mode Require Assistive Touch.
     * Indicates whether or not to require assistive touch while in kiosk mode.
     */
    @SerializedName(value = "kioskModeRequireAssistiveTouch", alternate = {"KioskModeRequireAssistiveTouch"})
    @Expose
	@Nullable
    public Boolean kioskModeRequireAssistiveTouch;

    /**
     * The Kiosk Mode Require Color Inversion.
     * Indicates whether or not to require color inversion while in kiosk mode.
     */
    @SerializedName(value = "kioskModeRequireColorInversion", alternate = {"KioskModeRequireColorInversion"})
    @Expose
	@Nullable
    public Boolean kioskModeRequireColorInversion;

    /**
     * The Kiosk Mode Require Mono Audio.
     * Indicates whether or not to require mono audio while in kiosk mode.
     */
    @SerializedName(value = "kioskModeRequireMonoAudio", alternate = {"KioskModeRequireMonoAudio"})
    @Expose
	@Nullable
    public Boolean kioskModeRequireMonoAudio;

    /**
     * The Kiosk Mode Require Voice Over.
     * Indicates whether or not to require voice over while in kiosk mode.
     */
    @SerializedName(value = "kioskModeRequireVoiceOver", alternate = {"KioskModeRequireVoiceOver"})
    @Expose
	@Nullable
    public Boolean kioskModeRequireVoiceOver;

    /**
     * The Kiosk Mode Require Zoom.
     * Indicates whether or not to require zoom while in kiosk mode.
     */
    @SerializedName(value = "kioskModeRequireZoom", alternate = {"KioskModeRequireZoom"})
    @Expose
	@Nullable
    public Boolean kioskModeRequireZoom;

    /**
     * The Lock Screen Block Control Center.
     * Indicates whether or not to block the user from using control center on the lock screen.
     */
    @SerializedName(value = "lockScreenBlockControlCenter", alternate = {"LockScreenBlockControlCenter"})
    @Expose
	@Nullable
    public Boolean lockScreenBlockControlCenter;

    /**
     * The Lock Screen Block Notification View.
     * Indicates whether or not to block the user from using the notification view on the lock screen.
     */
    @SerializedName(value = "lockScreenBlockNotificationView", alternate = {"LockScreenBlockNotificationView"})
    @Expose
	@Nullable
    public Boolean lockScreenBlockNotificationView;

    /**
     * The Lock Screen Block Passbook.
     * Indicates whether or not to block the user from using passbook when the device is locked.
     */
    @SerializedName(value = "lockScreenBlockPassbook", alternate = {"LockScreenBlockPassbook"})
    @Expose
	@Nullable
    public Boolean lockScreenBlockPassbook;

    /**
     * The Lock Screen Block Today View.
     * Indicates whether or not to block the user from using the Today View on the lock screen.
     */
    @SerializedName(value = "lockScreenBlockTodayView", alternate = {"LockScreenBlockTodayView"})
    @Expose
	@Nullable
    public Boolean lockScreenBlockTodayView;

    /**
     * The Media Content Rating Apps.
     * Media content rating settings for Apps. Possible values are: allAllowed, allBlocked, agesAbove4, agesAbove9, agesAbove12, agesAbove17.
     */
    @SerializedName(value = "mediaContentRatingApps", alternate = {"MediaContentRatingApps"})
    @Expose
	@Nullable
    public RatingAppsType mediaContentRatingApps;

    /**
     * The Media Content Rating Australia.
     * Media content rating settings for Australia
     */
    @SerializedName(value = "mediaContentRatingAustralia", alternate = {"MediaContentRatingAustralia"})
    @Expose
	@Nullable
    public MediaContentRatingAustralia mediaContentRatingAustralia;

    /**
     * The Media Content Rating Canada.
     * Media content rating settings for Canada
     */
    @SerializedName(value = "mediaContentRatingCanada", alternate = {"MediaContentRatingCanada"})
    @Expose
	@Nullable
    public MediaContentRatingCanada mediaContentRatingCanada;

    /**
     * The Media Content Rating France.
     * Media content rating settings for France
     */
    @SerializedName(value = "mediaContentRatingFrance", alternate = {"MediaContentRatingFrance"})
    @Expose
	@Nullable
    public MediaContentRatingFrance mediaContentRatingFrance;

    /**
     * The Media Content Rating Germany.
     * Media content rating settings for Germany
     */
    @SerializedName(value = "mediaContentRatingGermany", alternate = {"MediaContentRatingGermany"})
    @Expose
	@Nullable
    public MediaContentRatingGermany mediaContentRatingGermany;

    /**
     * The Media Content Rating Ireland.
     * Media content rating settings for Ireland
     */
    @SerializedName(value = "mediaContentRatingIreland", alternate = {"MediaContentRatingIreland"})
    @Expose
	@Nullable
    public MediaContentRatingIreland mediaContentRatingIreland;

    /**
     * The Media Content Rating Japan.
     * Media content rating settings for Japan
     */
    @SerializedName(value = "mediaContentRatingJapan", alternate = {"MediaContentRatingJapan"})
    @Expose
	@Nullable
    public MediaContentRatingJapan mediaContentRatingJapan;

    /**
     * The Media Content Rating New Zealand.
     * Media content rating settings for New Zealand
     */
    @SerializedName(value = "mediaContentRatingNewZealand", alternate = {"MediaContentRatingNewZealand"})
    @Expose
	@Nullable
    public MediaContentRatingNewZealand mediaContentRatingNewZealand;

    /**
     * The Media Content Rating United Kingdom.
     * Media content rating settings for United Kingdom
     */
    @SerializedName(value = "mediaContentRatingUnitedKingdom", alternate = {"MediaContentRatingUnitedKingdom"})
    @Expose
	@Nullable
    public MediaContentRatingUnitedKingdom mediaContentRatingUnitedKingdom;

    /**
     * The Media Content Rating United States.
     * Media content rating settings for United States
     */
    @SerializedName(value = "mediaContentRatingUnitedStates", alternate = {"MediaContentRatingUnitedStates"})
    @Expose
	@Nullable
    public MediaContentRatingUnitedStates mediaContentRatingUnitedStates;

    /**
     * The Messages Blocked.
     * Indicates whether or not to block the user from using the Messages app on the supervised device.
     */
    @SerializedName(value = "messagesBlocked", alternate = {"MessagesBlocked"})
    @Expose
	@Nullable
    public Boolean messagesBlocked;

    /**
     * The Network Usage Rules.
     * List of managed apps and the network rules that applies to them. This collection can contain a maximum of 1000 elements.
     */
    @SerializedName(value = "networkUsageRules", alternate = {"NetworkUsageRules"})
    @Expose
	@Nullable
    public java.util.List<IosNetworkUsageRule> networkUsageRules;

    /**
     * The Notifications Block Settings Modification.
     * Indicates whether or not to allow notifications settings modification (iOS 9.3 and later).
     */
    @SerializedName(value = "notificationsBlockSettingsModification", alternate = {"NotificationsBlockSettingsModification"})
    @Expose
	@Nullable
    public Boolean notificationsBlockSettingsModification;

    /**
     * The Passcode Block Fingerprint Modification.
     * Block modification of registered Touch ID fingerprints when in supervised mode.
     */
    @SerializedName(value = "passcodeBlockFingerprintModification", alternate = {"PasscodeBlockFingerprintModification"})
    @Expose
	@Nullable
    public Boolean passcodeBlockFingerprintModification;

    /**
     * The Passcode Block Fingerprint Unlock.
     * Indicates whether or not to block fingerprint unlock.
     */
    @SerializedName(value = "passcodeBlockFingerprintUnlock", alternate = {"PasscodeBlockFingerprintUnlock"})
    @Expose
	@Nullable
    public Boolean passcodeBlockFingerprintUnlock;

    /**
     * The Passcode Block Modification.
     * Indicates whether or not to allow passcode modification on the supervised device (iOS 9.0 and later).
     */
    @SerializedName(value = "passcodeBlockModification", alternate = {"PasscodeBlockModification"})
    @Expose
	@Nullable
    public Boolean passcodeBlockModification;

    /**
     * The Passcode Block Simple.
     * Indicates whether or not to block simple passcodes.
     */
    @SerializedName(value = "passcodeBlockSimple", alternate = {"PasscodeBlockSimple"})
    @Expose
	@Nullable
    public Boolean passcodeBlockSimple;

    /**
     * The Passcode Expiration Days.
     * Number of days before the passcode expires. Valid values 1 to 65535
     */
    @SerializedName(value = "passcodeExpirationDays", alternate = {"PasscodeExpirationDays"})
    @Expose
	@Nullable
    public Integer passcodeExpirationDays;

    /**
     * The Passcode Minimum Character Set Count.
     * Number of character sets a passcode must contain. Valid values 0 to 4
     */
    @SerializedName(value = "passcodeMinimumCharacterSetCount", alternate = {"PasscodeMinimumCharacterSetCount"})
    @Expose
	@Nullable
    public Integer passcodeMinimumCharacterSetCount;

    /**
     * The Passcode Minimum Length.
     * Minimum length of passcode. Valid values 4 to 14
     */
    @SerializedName(value = "passcodeMinimumLength", alternate = {"PasscodeMinimumLength"})
    @Expose
	@Nullable
    public Integer passcodeMinimumLength;

    /**
     * The Passcode Minutes Of Inactivity Before Lock.
     * Minutes of inactivity before a passcode is required.
     */
    @SerializedName(value = "passcodeMinutesOfInactivityBeforeLock", alternate = {"PasscodeMinutesOfInactivityBeforeLock"})
    @Expose
	@Nullable
    public Integer passcodeMinutesOfInactivityBeforeLock;

    /**
     * The Passcode Minutes Of Inactivity Before Screen Timeout.
     * Minutes of inactivity before the screen times out.
     */
    @SerializedName(value = "passcodeMinutesOfInactivityBeforeScreenTimeout", alternate = {"PasscodeMinutesOfInactivityBeforeScreenTimeout"})
    @Expose
	@Nullable
    public Integer passcodeMinutesOfInactivityBeforeScreenTimeout;

    /**
     * The Passcode Previous Passcode Block Count.
     * Number of previous passcodes to block. Valid values 1 to 24
     */
    @SerializedName(value = "passcodePreviousPasscodeBlockCount", alternate = {"PasscodePreviousPasscodeBlockCount"})
    @Expose
	@Nullable
    public Integer passcodePreviousPasscodeBlockCount;

    /**
     * The Passcode Required.
     * Indicates whether or not to require a passcode.
     */
    @SerializedName(value = "passcodeRequired", alternate = {"PasscodeRequired"})
    @Expose
	@Nullable
    public Boolean passcodeRequired;

    /**
     * The Passcode Required Type.
     * Type of passcode that is required. Possible values are: deviceDefault, alphanumeric, numeric.
     */
    @SerializedName(value = "passcodeRequiredType", alternate = {"PasscodeRequiredType"})
    @Expose
	@Nullable
    public RequiredPasswordType passcodeRequiredType;

    /**
     * The Passcode Sign In Failure Count Before Wipe.
     * Number of sign in failures allowed before wiping the device. Valid values 2 to 11
     */
    @SerializedName(value = "passcodeSignInFailureCountBeforeWipe", alternate = {"PasscodeSignInFailureCountBeforeWipe"})
    @Expose
	@Nullable
    public Integer passcodeSignInFailureCountBeforeWipe;

    /**
     * The Podcasts Blocked.
     * Indicates whether or not to block the user from using podcasts on the supervised device (iOS 8.0 and later).
     */
    @SerializedName(value = "podcastsBlocked", alternate = {"PodcastsBlocked"})
    @Expose
	@Nullable
    public Boolean podcastsBlocked;

    /**
     * The Safari Block Autofill.
     * Indicates whether or not to block the user from using Auto fill in Safari. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "safariBlockAutofill", alternate = {"SafariBlockAutofill"})
    @Expose
	@Nullable
    public Boolean safariBlockAutofill;

    /**
     * The Safari Blocked.
     * Indicates whether or not to block the user from using Safari. Requires a supervised device for iOS 13 and later.
     */
    @SerializedName(value = "safariBlocked", alternate = {"SafariBlocked"})
    @Expose
	@Nullable
    public Boolean safariBlocked;

    /**
     * The Safari Block Java Script.
     * Indicates whether or not to block JavaScript in Safari.
     */
    @SerializedName(value = "safariBlockJavaScript", alternate = {"SafariBlockJavaScript"})
    @Expose
	@Nullable
    public Boolean safariBlockJavaScript;

    /**
     * The Safari Block Popups.
     * Indicates whether or not to block popups in Safari.
     */
    @SerializedName(value = "safariBlockPopups", alternate = {"SafariBlockPopups"})
    @Expose
	@Nullable
    public Boolean safariBlockPopups;

    /**
     * The Safari Cookie Settings.
     * Cookie settings for Safari. Possible values are: browserDefault, blockAlways, allowCurrentWebSite, allowFromWebsitesVisited, allowAlways.
     */
    @SerializedName(value = "safariCookieSettings", alternate = {"SafariCookieSettings"})
    @Expose
	@Nullable
    public WebBrowserCookieSettings safariCookieSettings;

    /**
     * The Safari Managed Domains.
     * URLs matching the patterns listed here will be considered managed.
     */
    @SerializedName(value = "safariManagedDomains", alternate = {"SafariManagedDomains"})
    @Expose
	@Nullable
    public java.util.List<String> safariManagedDomains;

    /**
     * The Safari Password Auto Fill Domains.
     * Users can save passwords in Safari only from URLs matching the patterns listed here. Applies to devices in supervised mode (iOS 9.3 and later).
     */
    @SerializedName(value = "safariPasswordAutoFillDomains", alternate = {"SafariPasswordAutoFillDomains"})
    @Expose
	@Nullable
    public java.util.List<String> safariPasswordAutoFillDomains;

    /**
     * The Safari Require Fraud Warning.
     * Indicates whether or not to require fraud warning in Safari.
     */
    @SerializedName(value = "safariRequireFraudWarning", alternate = {"SafariRequireFraudWarning"})
    @Expose
	@Nullable
    public Boolean safariRequireFraudWarning;

    /**
     * The Screen Capture Blocked.
     * Indicates whether or not to block the user from taking Screenshots.
     */
    @SerializedName(value = "screenCaptureBlocked", alternate = {"ScreenCaptureBlocked"})
    @Expose
	@Nullable
    public Boolean screenCaptureBlocked;

    /**
     * The Siri Blocked.
     * Indicates whether or not to block the user from using Siri.
     */
    @SerializedName(value = "siriBlocked", alternate = {"SiriBlocked"})
    @Expose
	@Nullable
    public Boolean siriBlocked;

    /**
     * The Siri Blocked When Locked.
     * Indicates whether or not to block the user from using Siri when locked.
     */
    @SerializedName(value = "siriBlockedWhenLocked", alternate = {"SiriBlockedWhenLocked"})
    @Expose
	@Nullable
    public Boolean siriBlockedWhenLocked;

    /**
     * The Siri Block User Generated Content.
     * Indicates whether or not to block Siri from querying user-generated content when used on a supervised device.
     */
    @SerializedName(value = "siriBlockUserGeneratedContent", alternate = {"SiriBlockUserGeneratedContent"})
    @Expose
	@Nullable
    public Boolean siriBlockUserGeneratedContent;

    /**
     * The Siri Require Profanity Filter.
     * Indicates whether or not to prevent Siri from dictating, or speaking profane language on supervised device.
     */
    @SerializedName(value = "siriRequireProfanityFilter", alternate = {"SiriRequireProfanityFilter"})
    @Expose
	@Nullable
    public Boolean siriRequireProfanityFilter;

    /**
     * The Spotlight Block Internet Results.
     * Indicates whether or not to block Spotlight search from returning internet results on supervised device.
     */
    @SerializedName(value = "spotlightBlockInternetResults", alternate = {"SpotlightBlockInternetResults"})
    @Expose
	@Nullable
    public Boolean spotlightBlockInternetResults;

    /**
     * The Voice Dialing Blocked.
     * Indicates whether or not to block voice dialing.
     */
    @SerializedName(value = "voiceDialingBlocked", alternate = {"VoiceDialingBlocked"})
    @Expose
	@Nullable
    public Boolean voiceDialingBlocked;

    /**
     * The Wallpaper Block Modification.
     * Indicates whether or not to allow wallpaper modification on supervised device (iOS 9.0 and later) .
     */
    @SerializedName(value = "wallpaperBlockModification", alternate = {"WallpaperBlockModification"})
    @Expose
	@Nullable
    public Boolean wallpaperBlockModification;

    /**
     * The Wi Fi Connect Only To Configured Networks.
     * Indicates whether or not to force the device to use only Wi-Fi networks from configuration profiles when the device is in supervised mode.
     */
    @SerializedName(value = "wiFiConnectOnlyToConfiguredNetworks", alternate = {"WiFiConnectOnlyToConfiguredNetworks"})
    @Expose
	@Nullable
    public Boolean wiFiConnectOnlyToConfiguredNetworks;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
