/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.WebApp;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WebAppRequest
extends BaseRequest<WebApp> {
    public WebAppRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WebApp.class);
    }

    @Nonnull
    public CompletableFuture<WebApp> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public WebApp get() throws ClientException {
        return (WebApp)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<WebApp> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public WebApp delete() throws ClientException {
        return (WebApp)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<WebApp> patchAsync(@Nonnull WebApp sourceWebApp) {
        return this.sendAsync(HttpMethod.PATCH, sourceWebApp);
    }

    @Nullable
    public WebApp patch(@Nonnull WebApp sourceWebApp) throws ClientException {
        return (WebApp)this.send(HttpMethod.PATCH, sourceWebApp);
    }

    @Nonnull
    public CompletableFuture<WebApp> postAsync(@Nonnull WebApp newWebApp) {
        return this.sendAsync(HttpMethod.POST, newWebApp);
    }

    @Nullable
    public WebApp post(@Nonnull WebApp newWebApp) throws ClientException {
        return (WebApp)this.send(HttpMethod.POST, newWebApp);
    }

    @Nonnull
    public CompletableFuture<WebApp> putAsync(@Nonnull WebApp newWebApp) {
        return this.sendAsync(HttpMethod.PUT, newWebApp);
    }

    @Nullable
    public WebApp put(@Nonnull WebApp newWebApp) throws ClientException {
        return (WebApp)this.send(HttpMethod.PUT, newWebApp);
    }

    @Nonnull
    public WebAppRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WebAppRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

