/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.BaseItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.BaseItemCollectionPage;
import com.microsoft.graph.requests.BaseItemCollectionRequestBuilder;
import com.microsoft.graph.requests.BaseItemCollectionResponse;
import com.microsoft.graph.requests.BaseItemRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseItemCollectionRequest
extends BaseEntityCollectionRequest<BaseItem, BaseItemCollectionResponse, BaseItemCollectionPage> {
    public BaseItemCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseItemCollectionResponse.class, BaseItemCollectionPage.class, BaseItemCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<BaseItem> postAsync(@Nonnull BaseItem newBaseItem) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BaseItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newBaseItem);
    }

    @Nonnull
    public BaseItem post(@Nonnull BaseItem newBaseItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new BaseItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newBaseItem);
    }

    @Nonnull
    public BaseItemCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public BaseItemCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

