// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.WorkbookChartLegendFormat;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Legend.
 */
public class WorkbookChartLegend extends Entity implements IJsonBackedObject {


    /**
     * The Overlay.
     * Boolean value for whether the chart legend should overlap with the main body of the chart.
     */
    @SerializedName(value = "overlay", alternate = {"Overlay"})
    @Expose
	@Nullable
    public Boolean overlay;

    /**
     * The Position.
     * Represents the position of the legend on the chart. The possible values are: Top, Bottom, Left, Right, Corner, Custom.
     */
    @SerializedName(value = "position", alternate = {"Position"})
    @Expose
	@Nullable
    public String position;

    /**
     * The Visible.
     * A boolean value the represents the visibility of a ChartLegend object.
     */
    @SerializedName(value = "visible", alternate = {"Visible"})
    @Expose
	@Nullable
    public Boolean visible;

    /**
     * The Format.
     * Represents the formatting of a chart legend, which includes fill and font formatting. Read-only.
     */
    @SerializedName(value = "format", alternate = {"Format"})
    @Expose
	@Nullable
    public WorkbookChartLegendFormat format;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
