// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.ItemReference;
import com.microsoft.graph.models.SharingInvitation;
import com.microsoft.graph.models.SharingLink;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Permission.
 */
public class Permission extends Entity implements IJsonBackedObject {


    /**
     * The Expiration Date Time.
     * A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the expiration time of the permission. DateTime.MinValue indicates there is no expiration set for this permission. Optional.
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The Granted To.
     * For user type permissions, the details of the users &amp; applications for this permission. Read-only.
     */
    @SerializedName(value = "grantedTo", alternate = {"GrantedTo"})
    @Expose
	@Nullable
    public IdentitySet grantedTo;

    /**
     * The Granted To Identities.
     * For link type permissions, the details of the users to whom permission was granted. Read-only.
     */
    @SerializedName(value = "grantedToIdentities", alternate = {"GrantedToIdentities"})
    @Expose
	@Nullable
    public java.util.List<IdentitySet> grantedToIdentities;

    /**
     * The Has Password.
     * This indicates whether password is set for this permission, it's only showing in response. Optional and Read-only and for OneDrive Personal only.
     */
    @SerializedName(value = "hasPassword", alternate = {"HasPassword"})
    @Expose
	@Nullable
    public Boolean hasPassword;

    /**
     * The Inherited From.
     * Provides a reference to the ancestor of the current permission, if it is inherited from an ancestor. Read-only.
     */
    @SerializedName(value = "inheritedFrom", alternate = {"InheritedFrom"})
    @Expose
	@Nullable
    public ItemReference inheritedFrom;

    /**
     * The Invitation.
     * Details of any associated sharing invitation for this permission. Read-only.
     */
    @SerializedName(value = "invitation", alternate = {"Invitation"})
    @Expose
	@Nullable
    public SharingInvitation invitation;

    /**
     * The Link.
     * Provides the link details of the current permission, if it is a link type permissions. Read-only.
     */
    @SerializedName(value = "link", alternate = {"Link"})
    @Expose
	@Nullable
    public SharingLink link;

    /**
     * The Roles.
     * The type of permission, e.g. read. See below for the full list of roles. Read-only.
     */
    @SerializedName(value = "roles", alternate = {"Roles"})
    @Expose
	@Nullable
    public java.util.List<String> roles;

    /**
     * The Share Id.
     * A unique token that can be used to access this shared item via the **shares** API. Read-only.
     */
    @SerializedName(value = "shareId", alternate = {"ShareId"})
    @Expose
	@Nullable
    public String shareId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
