/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Team;
import com.microsoft.graph.models.TeamArchiveParameterSet;
import com.microsoft.graph.models.TeamCloneParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ChannelCollectionRequestBuilder;
import com.microsoft.graph.requests.ChannelRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberRequestBuilder;
import com.microsoft.graph.requests.GroupWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ScheduleRequestBuilder;
import com.microsoft.graph.requests.TeamArchiveRequestBuilder;
import com.microsoft.graph.requests.TeamCloneRequestBuilder;
import com.microsoft.graph.requests.TeamCompleteMigrationRequestBuilder;
import com.microsoft.graph.requests.TeamRequest;
import com.microsoft.graph.requests.TeamUnarchiveRequestBuilder;
import com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder;
import com.microsoft.graph.requests.TeamsAsyncOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.TeamsAsyncOperationRequestBuilder;
import com.microsoft.graph.requests.TeamsTemplateWithReferenceRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TeamRequestBuilder
extends BaseRequestBuilder<Team> {
    public TeamRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public TeamRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public TeamRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new TeamRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public ScheduleRequestBuilder schedule() {
        return new ScheduleRequestBuilder(this.getRequestUrlWithAdditionalSegment("schedule"), this.getClient(), null);
    }

    @Nonnull
    public ChannelCollectionRequestBuilder channels() {
        return new ChannelCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("channels"), this.getClient(), null);
    }

    @Nonnull
    public ChannelRequestBuilder channels(@Nonnull String id) {
        return new ChannelRequestBuilder(this.getRequestUrlWithAdditionalSegment("channels") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public GroupWithReferenceRequestBuilder group() {
        return new GroupWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("group"), this.getClient(), null);
    }

    @Nonnull
    public TeamsAppInstallationCollectionRequestBuilder installedApps() {
        return new TeamsAppInstallationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("installedApps"), this.getClient(), null);
    }

    @Nonnull
    public TeamsAppInstallationRequestBuilder installedApps(@Nonnull String id) {
        return new TeamsAppInstallationRequestBuilder(this.getRequestUrlWithAdditionalSegment("installedApps") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ConversationMemberCollectionRequestBuilder members() {
        return new ConversationMemberCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("members"), this.getClient(), null);
    }

    @Nonnull
    public ConversationMemberRequestBuilder members(@Nonnull String id) {
        return new ConversationMemberRequestBuilder(this.getRequestUrlWithAdditionalSegment("members") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public TeamsAsyncOperationCollectionRequestBuilder operations() {
        return new TeamsAsyncOperationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("operations"), this.getClient(), null);
    }

    @Nonnull
    public TeamsAsyncOperationRequestBuilder operations(@Nonnull String id) {
        return new TeamsAsyncOperationRequestBuilder(this.getRequestUrlWithAdditionalSegment("operations") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ChannelRequestBuilder primaryChannel() {
        return new ChannelRequestBuilder(this.getRequestUrlWithAdditionalSegment("primaryChannel"), this.getClient(), null);
    }

    @Nonnull
    public TeamsTemplateWithReferenceRequestBuilder template() {
        return new TeamsTemplateWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("template"), this.getClient(), null);
    }

    @Nonnull
    public TeamArchiveRequestBuilder archive(@Nonnull TeamArchiveParameterSet parameters) {
        return new TeamArchiveRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.archive"), this.getClient(), null, parameters);
    }

    @Nonnull
    public TeamCloneRequestBuilder clone(@Nonnull TeamCloneParameterSet parameters) {
        return new TeamCloneRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.clone"), this.getClient(), null, parameters);
    }

    @Nonnull
    public TeamCompleteMigrationRequestBuilder completeMigration() {
        return new TeamCompleteMigrationRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.completeMigration"), this.getClient(), null);
    }

    @Nonnull
    public TeamUnarchiveRequestBuilder unarchive() {
        return new TeamUnarchiveRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.unarchive"), this.getClient(), null);
    }
}

