// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookRangeFill;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Fill Request.
 */
public class WorkbookRangeFillRequest extends BaseRequest<WorkbookRangeFill> {
	
    /**
     * The request for the WorkbookRangeFill
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeFillRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeFill.class);
    }

    /**
     * Gets the WorkbookRangeFill from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFill> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookRangeFill from the service
     *
     * @return the WorkbookRangeFill from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFill get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFill> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookRangeFill delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookRangeFill with a source
     *
     * @param sourceWorkbookRangeFill the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFill> patchAsync(@Nonnull final WorkbookRangeFill sourceWorkbookRangeFill) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookRangeFill);
    }

    /**
     * Patches this WorkbookRangeFill with a source
     *
     * @param sourceWorkbookRangeFill the source object with updates
     * @return the updated WorkbookRangeFill
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFill patch(@Nonnull final WorkbookRangeFill sourceWorkbookRangeFill) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeFill);
    }

    /**
     * Creates a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFill> postAsync(@Nonnull final WorkbookRangeFill newWorkbookRangeFill) {
        return sendAsync(HttpMethod.POST, newWorkbookRangeFill);
    }

    /**
     * Creates a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the new object to create
     * @return the created WorkbookRangeFill
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFill post(@Nonnull final WorkbookRangeFill newWorkbookRangeFill) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeFill);
    }

    /**
     * Creates a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeFill> putAsync(@Nonnull final WorkbookRangeFill newWorkbookRangeFill) {
        return sendAsync(HttpMethod.PUT, newWorkbookRangeFill);
    }

    /**
     * Creates a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the object to create/update
     * @return the created WorkbookRangeFill
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeFill put(@Nonnull final WorkbookRangeFill newWorkbookRangeFill) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookRangeFill);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeFillRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeFillRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

