// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.TeamsAppPublishingState;
import com.microsoft.graph.models.TeamworkBot;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams App Definition.
 */
public class TeamsAppDefinition extends Entity implements IJsonBackedObject {


    /**
     * The Created By.
     * 
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public IdentitySet createdBy;

    /**
     * The Description.
     * Verbose description of the application.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The name of the app provided by the app developer.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Last Modified Date Time.
     * 
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Publishing State.
     * The published status of a specific version of a Teams app. Possible values are:submitted — The specific version of the Teams app has been submitted and is under review. published  — The request to publish the specific version of the Teams app has been approved by the admin and the app is published.  rejected — The request to publish the specific version of the Teams app was rejected by the admin.
     */
    @SerializedName(value = "publishingState", alternate = {"PublishingState"})
    @Expose
	@Nullable
    public TeamsAppPublishingState publishingState;

    /**
     * The Short Description.
     * Short description of the application.
     */
    @SerializedName(value = "shortDescription", alternate = {"ShortDescription"})
    @Expose
	@Nullable
    public String shortDescription;

    /**
     * The Teams App Id.
     * The id from the Teams App manifest.
     */
    @SerializedName(value = "teamsAppId", alternate = {"TeamsAppId"})
    @Expose
	@Nullable
    public String teamsAppId;

    /**
     * The Version.
     * The version number of the application.
     */
    @SerializedName(value = "version", alternate = {"Version"})
    @Expose
	@Nullable
    public String version;

    /**
     * The Bot.
     * The details of the bot specified in the Teams App manifest.
     */
    @SerializedName(value = "bot", alternate = {"Bot"})
    @Expose
	@Nullable
    public TeamworkBot bot;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
