/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.PrintCertificateSigningRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.IPrinterCreateRequest;
import com.microsoft.graph.requests.extensions.IPrinterCreateRequestBuilder;
import com.microsoft.graph.requests.extensions.PrinterCreateRequest;
import java.util.List;

public class PrinterCreateRequestBuilder
extends BaseActionRequestBuilder
implements IPrinterCreateRequestBuilder {
    public PrinterCreateRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, String displayName, String manufacturer, String model, String physicalDeviceId, Boolean hasPhysicalDevice, PrintCertificateSigningRequest certificateSigningRequest, String connectorId) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("displayName", displayName);
        this.bodyParams.put("manufacturer", manufacturer);
        this.bodyParams.put("model", model);
        this.bodyParams.put("physicalDeviceId", physicalDeviceId);
        this.bodyParams.put("hasPhysicalDevice", hasPhysicalDevice);
        this.bodyParams.put("certificateSigningRequest", certificateSigningRequest);
        this.bodyParams.put("connectorId", connectorId);
    }

    @Override
    public IPrinterCreateRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public IPrinterCreateRequest buildRequest(List<? extends Option> requestOptions) {
        PrinterCreateRequest request = new PrinterCreateRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("displayName")) {
            request.body.displayName = (String)this.getParameter("displayName");
        }
        if (this.hasParameter("manufacturer")) {
            request.body.manufacturer = (String)this.getParameter("manufacturer");
        }
        if (this.hasParameter("model")) {
            request.body.model = (String)this.getParameter("model");
        }
        if (this.hasParameter("physicalDeviceId")) {
            request.body.physicalDeviceId = (String)this.getParameter("physicalDeviceId");
        }
        if (this.hasParameter("hasPhysicalDevice")) {
            request.body.hasPhysicalDevice = (Boolean)this.getParameter("hasPhysicalDevice");
        }
        if (this.hasParameter("certificateSigningRequest")) {
            request.body.certificateSigningRequest = (PrintCertificateSigningRequest)this.getParameter("certificateSigningRequest");
        }
        if (this.hasParameter("connectorId")) {
            request.body.connectorId = (String)this.getParameter("connectorId");
        }
        return request;
    }
}

