/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintDocument;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintDocumentCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintDocumentCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintDocumentCollectionPage;
import com.microsoft.graph.requests.extensions.PrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintDocumentCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintDocumentRequestBuilder;
import java.util.List;

public class PrintDocumentCollectionRequest
extends BaseCollectionRequest<PrintDocumentCollectionResponse, IPrintDocumentCollectionPage>
implements IPrintDocumentCollectionRequest {
    public PrintDocumentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintDocumentCollectionResponse.class, IPrintDocumentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintDocumentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintDocumentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintDocumentCollectionPage get() throws ClientException {
        PrintDocumentCollectionResponse response = (PrintDocumentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintDocument newPrintDocument, ICallback<? super PrintDocument> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintDocumentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintDocument, callback);
    }

    @Override
    public PrintDocument post(PrintDocument newPrintDocument) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintDocumentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintDocument);
    }

    @Override
    public IPrintDocumentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintDocumentCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintDocumentCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintDocumentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintDocumentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintDocumentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintDocumentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintDocumentCollectionPage buildFromResponse(PrintDocumentCollectionResponse response) {
        PrintDocumentCollectionRequestBuilder builder = response.nextLink != null ? new PrintDocumentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintDocumentCollectionPage page = new PrintDocumentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

