/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.ChatRequest;
import com.microsoft.graph.requests.extensions.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ConversationMemberRequestBuilder;
import com.microsoft.graph.requests.extensions.IChatRequest;
import com.microsoft.graph.requests.extensions.IChatRequestBuilder;
import com.microsoft.graph.requests.extensions.IConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IConversationMemberRequestBuilder;
import com.microsoft.graph.requests.extensions.ITeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITeamsAppInstallationRequestBuilder;
import com.microsoft.graph.requests.extensions.ITeamsTabCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITeamsTabRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAppInstallationRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsTabCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsTabRequestBuilder;
import java.util.List;

public class ChatRequestBuilder
extends BaseRequestBuilder
implements IChatRequestBuilder {
    public ChatRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Override
    public IChatRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public IChatRequest buildRequest(List<? extends Option> requestOptions) {
        return new ChatRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Override
    public ITeamsAppInstallationCollectionRequestBuilder installedApps() {
        return new TeamsAppInstallationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("installedApps"), this.getClient(), null);
    }

    @Override
    public ITeamsAppInstallationRequestBuilder installedApps(String id) {
        return new TeamsAppInstallationRequestBuilder(this.getRequestUrlWithAdditionalSegment("installedApps") + "/" + id, this.getClient(), null);
    }

    @Override
    public IConversationMemberCollectionRequestBuilder members() {
        return new ConversationMemberCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("members"), this.getClient(), null);
    }

    @Override
    public IConversationMemberRequestBuilder members(String id) {
        return new ConversationMemberRequestBuilder(this.getRequestUrlWithAdditionalSegment("members") + "/" + id, this.getClient(), null);
    }

    @Override
    public ITeamsTabCollectionRequestBuilder tabs() {
        return new TeamsTabCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("tabs"), this.getClient(), null);
    }

    @Override
    public ITeamsTabRequestBuilder tabs(String id) {
        return new TeamsTabRequestBuilder(this.getRequestUrlWithAdditionalSegment("tabs") + "/" + id, this.getClient(), null);
    }
}

