/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionResponse;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionPage;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionWithReferencesRequest;
import java.util.List;

public class AgreementAcceptanceCollectionWithReferencesRequest
extends BaseCollectionRequest<AgreementAcceptanceCollectionResponse, IAgreementAcceptanceCollectionPage>
implements IAgreementAcceptanceCollectionWithReferencesRequest {
    public AgreementAcceptanceCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementAcceptanceCollectionResponse.class, IAgreementAcceptanceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAgreementAcceptanceCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AgreementAcceptanceCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAgreementAcceptanceCollectionWithReferencesPage get() throws ClientException {
        AgreementAcceptanceCollectionResponse response = (AgreementAcceptanceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IAgreementAcceptanceCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IAgreementAcceptanceCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IAgreementAcceptanceCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAgreementAcceptanceCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IAgreementAcceptanceCollectionWithReferencesPage buildFromResponse(AgreementAcceptanceCollectionResponse response) {
        AgreementAcceptanceCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new AgreementAcceptanceCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AgreementAcceptanceCollectionWithReferencesPage page = new AgreementAcceptanceCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

