/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ServicePrincipal;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IServicePrincipalWithReferenceRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;

public class ServicePrincipalWithReferenceRequest
extends BaseRequest
implements IServicePrincipalWithReferenceRequest {
    public ServicePrincipalWithReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipal.class);
    }

    @Override
    public void post(ServicePrincipal newServicePrincipal, IJsonBackedObject payload, ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.POST, callback, payload);
    }

    @Override
    public ServicePrincipal post(ServicePrincipal newServicePrincipal, IJsonBackedObject payload) throws ClientException {
        IJsonBackedObject response = (IJsonBackedObject)this.send(HttpMethod.POST, payload);
        if (response != null) {
            return newServicePrincipal;
        }
        return null;
    }

    @Override
    public void get(ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ServicePrincipal get() throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ServicePrincipal sourceServicePrincipal, ICallback<? super ServicePrincipal> callback) {
        this.send(HttpMethod.PATCH, callback, sourceServicePrincipal);
    }

    @Override
    public ServicePrincipal patch(ServicePrincipal sourceServicePrincipal) throws ClientException {
        return (ServicePrincipal)this.send(HttpMethod.PATCH, sourceServicePrincipal);
    }

    @Override
    public IServicePrincipalWithReferenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IServicePrincipalWithReferenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

