/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AuthenticationMethodTarget;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AuthenticationMethodTargetCollectionPage;
import com.microsoft.graph.requests.extensions.AuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodTargetCollectionResponse;
import com.microsoft.graph.requests.extensions.AuthenticationMethodTargetRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodTargetCollectionPage;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodTargetCollectionRequest;
import java.util.List;

public class AuthenticationMethodTargetCollectionRequest
extends BaseCollectionRequest<AuthenticationMethodTargetCollectionResponse, IAuthenticationMethodTargetCollectionPage>
implements IAuthenticationMethodTargetCollectionRequest {
    public AuthenticationMethodTargetCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodTargetCollectionResponse.class, IAuthenticationMethodTargetCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAuthenticationMethodTargetCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AuthenticationMethodTargetCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAuthenticationMethodTargetCollectionPage get() throws ClientException {
        AuthenticationMethodTargetCollectionResponse response = (AuthenticationMethodTargetCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AuthenticationMethodTarget newAuthenticationMethodTarget, ICallback<? super AuthenticationMethodTarget> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AuthenticationMethodTargetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethodTarget, callback);
    }

    @Override
    public AuthenticationMethodTarget post(AuthenticationMethodTarget newAuthenticationMethodTarget) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthenticationMethodTargetRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethodTarget);
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAuthenticationMethodTargetCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAuthenticationMethodTargetCollectionPage buildFromResponse(AuthenticationMethodTargetCollectionResponse response) {
        AuthenticationMethodTargetCollectionRequestBuilder builder = response.nextLink != null ? new AuthenticationMethodTargetCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AuthenticationMethodTargetCollectionPage page = new AuthenticationMethodTargetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

