/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteGetActivitiesByIntervalCollectionPage;
import com.microsoft.graph.requests.extensions.ISiteGetActivitiesByIntervalCollectionRequest;
import com.microsoft.graph.requests.extensions.SiteGetActivitiesByIntervalCollectionPage;
import com.microsoft.graph.requests.extensions.SiteGetActivitiesByIntervalCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SiteGetActivitiesByIntervalCollectionResponse;
import java.util.List;

public class SiteGetActivitiesByIntervalCollectionRequest
extends BaseCollectionRequest<SiteGetActivitiesByIntervalCollectionResponse, ISiteGetActivitiesByIntervalCollectionPage>
implements ISiteGetActivitiesByIntervalCollectionRequest {
    public SiteGetActivitiesByIntervalCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteGetActivitiesByIntervalCollectionResponse.class, ISiteGetActivitiesByIntervalCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ISiteGetActivitiesByIntervalCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SiteGetActivitiesByIntervalCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISiteGetActivitiesByIntervalCollectionPage get() throws ClientException {
        SiteGetActivitiesByIntervalCollectionResponse response = (SiteGetActivitiesByIntervalCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public ISiteGetActivitiesByIntervalCollectionPage buildFromResponse(SiteGetActivitiesByIntervalCollectionResponse response) {
        SiteGetActivitiesByIntervalCollectionRequestBuilder builder = response.nextLink != null ? new SiteGetActivitiesByIntervalCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SiteGetActivitiesByIntervalCollectionPage page = new SiteGetActivitiesByIntervalCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ISiteGetActivitiesByIntervalCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteGetActivitiesByIntervalCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISiteGetActivitiesByIntervalCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ISiteGetActivitiesByIntervalCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ISiteGetActivitiesByIntervalCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

