/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Room;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRoomRequest;
import java.util.List;

public class RoomRequest
extends BaseRequest
implements IRoomRequest {
    public RoomRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Room.class);
    }

    @Override
    public void get(ICallback<? super Room> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Room get() throws ClientException {
        return (Room)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Room> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Room sourceRoom, ICallback<? super Room> callback) {
        this.send(HttpMethod.PATCH, callback, sourceRoom);
    }

    @Override
    public Room patch(Room sourceRoom) throws ClientException {
        return (Room)this.send(HttpMethod.PATCH, sourceRoom);
    }

    @Override
    public void post(Room newRoom, ICallback<? super Room> callback) {
        this.send(HttpMethod.POST, callback, newRoom);
    }

    @Override
    public Room post(Room newRoom) throws ClientException {
        return (Room)this.send(HttpMethod.POST, newRoom);
    }

    @Override
    public void put(Room newRoom, ICallback<? super Room> callback) {
        this.send(HttpMethod.PUT, callback, newRoom);
    }

    @Override
    public Room put(Room newRoom) throws ClientException {
        return (Room)this.send(HttpMethod.PUT, newRoom);
    }

    @Override
    public IRoomRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRoomRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

