/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOrgContactCollectionPage;
import com.microsoft.graph.requests.extensions.IOrgContactCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IOrgContactCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.OrgContactCollectionResponse;
import com.microsoft.graph.requests.extensions.OrgContactCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.OrgContactCollectionWithReferencesRequestBuilder;
import java.util.List;

public class OrgContactCollectionWithReferencesRequest
extends BaseCollectionRequest<OrgContactCollectionResponse, IOrgContactCollectionPage>
implements IOrgContactCollectionWithReferencesRequest {
    public OrgContactCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrgContactCollectionResponse.class, IOrgContactCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOrgContactCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OrgContactCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOrgContactCollectionWithReferencesPage get() throws ClientException {
        OrgContactCollectionResponse response = (OrgContactCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IOrgContactCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IOrgContactCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IOrgContactCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOrgContactCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOrgContactCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOrgContactCollectionWithReferencesPage buildFromResponse(OrgContactCollectionResponse response) {
        OrgContactCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new OrgContactCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OrgContactCollectionWithReferencesPage page = new OrgContactCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

