/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OnenoteResource;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOnenoteResourceCollectionPage;
import com.microsoft.graph.requests.extensions.IOnenoteResourceCollectionRequest;
import com.microsoft.graph.requests.extensions.OnenoteResourceCollectionPage;
import com.microsoft.graph.requests.extensions.OnenoteResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenoteResourceCollectionResponse;
import com.microsoft.graph.requests.extensions.OnenoteResourceRequestBuilder;
import java.util.List;

public class OnenoteResourceCollectionRequest
extends BaseCollectionRequest<OnenoteResourceCollectionResponse, IOnenoteResourceCollectionPage>
implements IOnenoteResourceCollectionRequest {
    public OnenoteResourceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteResourceCollectionResponse.class, IOnenoteResourceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOnenoteResourceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OnenoteResourceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenoteResourceCollectionPage get() throws ClientException {
        OnenoteResourceCollectionResponse response = (OnenoteResourceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OnenoteResource newOnenoteResource, ICallback<? super OnenoteResource> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenoteResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOnenoteResource, callback);
    }

    @Override
    public OnenoteResource post(OnenoteResource newOnenoteResource) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenoteResourceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOnenoteResource);
    }

    @Override
    public IOnenoteResourceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOnenoteResourceCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOnenoteResourceCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOnenoteResourceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOnenoteResourceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOnenoteResourceCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOnenoteResourceCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOnenoteResourceCollectionPage buildFromResponse(OnenoteResourceCollectionResponse response) {
        OnenoteResourceCollectionRequestBuilder builder = response.nextLink != null ? new OnenoteResourceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenoteResourceCollectionPage page = new OnenoteResourceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

