/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.IdentityProvider;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IIdentityProviderCollectionPage;
import com.microsoft.graph.requests.extensions.IIdentityProviderCollectionRequest;
import com.microsoft.graph.requests.extensions.IdentityProviderCollectionPage;
import com.microsoft.graph.requests.extensions.IdentityProviderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IdentityProviderCollectionResponse;
import com.microsoft.graph.requests.extensions.IdentityProviderRequestBuilder;
import java.util.List;

public class IdentityProviderCollectionRequest
extends BaseCollectionRequest<IdentityProviderCollectionResponse, IIdentityProviderCollectionPage>
implements IIdentityProviderCollectionRequest {
    public IdentityProviderCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityProviderCollectionResponse.class, IIdentityProviderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IIdentityProviderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(IdentityProviderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IIdentityProviderCollectionPage get() throws ClientException {
        IdentityProviderCollectionResponse response = (IdentityProviderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(IdentityProvider newIdentityProvider, ICallback<? super IdentityProvider> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new IdentityProviderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIdentityProvider, callback);
    }

    @Override
    public IdentityProvider post(IdentityProvider newIdentityProvider) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IdentityProviderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIdentityProvider);
    }

    @Override
    public IIdentityProviderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IIdentityProviderCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IIdentityProviderCollectionPage buildFromResponse(IdentityProviderCollectionResponse response) {
        IdentityProviderCollectionRequestBuilder builder = response.nextLink != null ? new IdentityProviderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        IdentityProviderCollectionPage page = new IdentityProviderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

