/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceManagementPartner;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceManagementPartnerRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceManagementPartnerCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceManagementPartnerCollectionRequest;
import java.util.List;

public class DeviceManagementPartnerCollectionRequest
extends BaseCollectionRequest<DeviceManagementPartnerCollectionResponse, IDeviceManagementPartnerCollectionPage>
implements IDeviceManagementPartnerCollectionRequest {
    public DeviceManagementPartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementPartnerCollectionResponse.class, IDeviceManagementPartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceManagementPartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceManagementPartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceManagementPartnerCollectionPage get() throws ClientException {
        DeviceManagementPartnerCollectionResponse response = (DeviceManagementPartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceManagementPartner newDeviceManagementPartner, ICallback<? super DeviceManagementPartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceManagementPartner, callback);
    }

    @Override
    public DeviceManagementPartner post(DeviceManagementPartner newDeviceManagementPartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceManagementPartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceManagementPartner);
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceManagementPartnerCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceManagementPartnerCollectionPage buildFromResponse(DeviceManagementPartnerCollectionResponse response) {
        DeviceManagementPartnerCollectionRequestBuilder builder = response.nextLink != null ? new DeviceManagementPartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceManagementPartnerCollectionPage page = new DeviceManagementPartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

