/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Calendar;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ICalendarRequest;
import java.util.List;

public class CalendarRequest
extends BaseRequest
implements ICalendarRequest {
    public CalendarRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Calendar.class);
    }

    @Override
    public void get(ICallback<? super Calendar> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Calendar get() throws ClientException {
        return (Calendar)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Calendar> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Calendar sourceCalendar, ICallback<? super Calendar> callback) {
        this.send(HttpMethod.PATCH, callback, sourceCalendar);
    }

    @Override
    public Calendar patch(Calendar sourceCalendar) throws ClientException {
        return (Calendar)this.send(HttpMethod.PATCH, sourceCalendar);
    }

    @Override
    public void post(Calendar newCalendar, ICallback<? super Calendar> callback) {
        this.send(HttpMethod.POST, callback, newCalendar);
    }

    @Override
    public Calendar post(Calendar newCalendar) throws ClientException {
        return (Calendar)this.send(HttpMethod.POST, newCalendar);
    }

    @Override
    public void put(Calendar newCalendar, ICallback<? super Calendar> callback) {
        this.send(HttpMethod.PUT, callback, newCalendar);
    }

    @Override
    public Calendar put(Calendar newCalendar) throws ClientException {
        return (Calendar)this.send(HttpMethod.PUT, newCalendar);
    }

    @Override
    public ICalendarRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICalendarRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

