// Template Source: BaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MobileAppCategory;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Category Reference Request.
 */
public class MobileAppCategoryReferenceRequest extends BaseRequest implements IMobileAppCategoryReferenceRequest {

    /**
     * The request for the MobileAppCategory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppCategoryReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCategory.class);
    }

    public void delete(final ICallback<? super MobileAppCategory> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public MobileAppCategory delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IMobileAppCategoryReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (MobileAppCategoryReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IMobileAppCategoryReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (MobileAppCategoryReferenceRequest)this;
    }
    /**
     * Puts the MobileAppCategory
     *
     * @param srcMobileAppCategory the MobileAppCategory reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(MobileAppCategory srcMobileAppCategory, final ICallback<? super MobileAppCategory> callback) {
        send(HttpMethod.PUT, callback, srcMobileAppCategory);
    }

    /**
     * Puts the MobileAppCategory
     *
     * @param srcMobileAppCategory the MobileAppCategory reference to PUT
     * @return the MobileAppCategory
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public MobileAppCategory put(MobileAppCategory srcMobileAppCategory) throws ClientException {
        return send(HttpMethod.PUT, srcMobileAppCategory);
    }
}
