// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.OnenoteSection;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Onenote Section Request.
 */
public interface IOnenoteSectionRequest extends IHttpRequest {

    /**
     * Gets the OnenoteSection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super OnenoteSection> callback);

    /**
     * Gets the OnenoteSection from the service
     *
     * @return the OnenoteSection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteSection get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super OnenoteSection> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OnenoteSection with a source
     *
     * @param sourceOnenoteSection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final OnenoteSection sourceOnenoteSection, final ICallback<? super OnenoteSection> callback);

    /**
     * Patches this OnenoteSection with a source
     *
     * @param sourceOnenoteSection the source object with updates
     * @return the updated OnenoteSection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteSection patch(final OnenoteSection sourceOnenoteSection) throws ClientException;

    /**
     * Posts a OnenoteSection with a new object
     *
     * @param newOnenoteSection the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final OnenoteSection newOnenoteSection, final ICallback<? super OnenoteSection> callback);

    /**
     * Posts a OnenoteSection with a new object
     *
     * @param newOnenoteSection the new object to create
     * @return the created OnenoteSection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteSection post(final OnenoteSection newOnenoteSection) throws ClientException;

    /**
     * Posts a OnenoteSection with a new object
     *
     * @param newOnenoteSection the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final OnenoteSection newOnenoteSection, final ICallback<? super OnenoteSection> callback);

    /**
     * Posts a OnenoteSection with a new object
     *
     * @param newOnenoteSection the object to create/update
     * @return the created OnenoteSection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteSection put(final OnenoteSection newOnenoteSection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOnenoteSectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOnenoteSectionRequest expand(final String value);

}

