// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Authentication;
import com.microsoft.graph.requests.extensions.IFido2AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IFido2AuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IWindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWindowsHelloForBusinessAuthenticationMethodRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Authentication Request Builder.
 */
public interface IAuthenticationRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IAuthenticationRequest instance
     */
    IAuthenticationRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IAuthenticationRequest instance
     */
    IAuthenticationRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IFido2AuthenticationMethodCollectionRequestBuilder fido2Methods();

    IFido2AuthenticationMethodRequestBuilder fido2Methods(final String id);

    IAuthenticationMethodCollectionRequestBuilder methods();

    IAuthenticationMethodRequestBuilder methods(final String id);

    IMicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder microsoftAuthenticatorMethods();

    IMicrosoftAuthenticatorAuthenticationMethodRequestBuilder microsoftAuthenticatorMethods(final String id);

    IWindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder windowsHelloForBusinessMethods();

    IWindowsHelloForBusinessAuthenticationMethodRequestBuilder windowsHelloForBusinessMethods(final String id);

}