/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TodoTaskList;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITodoTaskListCollectionPage;
import com.microsoft.graph.requests.extensions.ITodoTaskListCollectionRequest;
import com.microsoft.graph.requests.extensions.TodoTaskListCollectionPage;
import com.microsoft.graph.requests.extensions.TodoTaskListCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskListCollectionResponse;
import com.microsoft.graph.requests.extensions.TodoTaskListRequestBuilder;
import java.util.List;

public class TodoTaskListCollectionRequest
extends BaseCollectionRequest<TodoTaskListCollectionResponse, ITodoTaskListCollectionPage>
implements ITodoTaskListCollectionRequest {
    public TodoTaskListCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskListCollectionResponse.class, ITodoTaskListCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITodoTaskListCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TodoTaskListCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITodoTaskListCollectionPage get() throws ClientException {
        TodoTaskListCollectionResponse response = (TodoTaskListCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TodoTaskList newTodoTaskList, ICallback<? super TodoTaskList> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TodoTaskListRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTodoTaskList, callback);
    }

    @Override
    public TodoTaskList post(TodoTaskList newTodoTaskList) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TodoTaskListRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTodoTaskList);
    }

    @Override
    public ITodoTaskListCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITodoTaskListCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITodoTaskListCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITodoTaskListCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITodoTaskListCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITodoTaskListCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITodoTaskListCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITodoTaskListCollectionPage buildFromResponse(TodoTaskListCollectionResponse response) {
        TodoTaskListCollectionRequestBuilder builder = response.nextLink != null ? new TodoTaskListCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TodoTaskListCollectionPage page = new TodoTaskListCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

