/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.StsPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IStsPolicyRequest;
import java.util.List;

public class StsPolicyRequest
extends BaseRequest
implements IStsPolicyRequest {
    public StsPolicyRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends StsPolicy> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public StsPolicyRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, StsPolicy.class);
    }

    @Override
    public void get(ICallback<? super StsPolicy> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public StsPolicy get() throws ClientException {
        return (StsPolicy)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super StsPolicy> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(StsPolicy sourceStsPolicy, ICallback<? super StsPolicy> callback) {
        this.send(HttpMethod.PATCH, callback, sourceStsPolicy);
    }

    @Override
    public StsPolicy patch(StsPolicy sourceStsPolicy) throws ClientException {
        return (StsPolicy)this.send(HttpMethod.PATCH, sourceStsPolicy);
    }

    @Override
    public void post(StsPolicy newStsPolicy, ICallback<? super StsPolicy> callback) {
        this.send(HttpMethod.POST, callback, newStsPolicy);
    }

    @Override
    public StsPolicy post(StsPolicy newStsPolicy) throws ClientException {
        return (StsPolicy)this.send(HttpMethod.POST, newStsPolicy);
    }

    @Override
    public void put(StsPolicy newStsPolicy, ICallback<? super StsPolicy> callback) {
        this.send(HttpMethod.PUT, callback, newStsPolicy);
    }

    @Override
    public StsPolicy put(StsPolicy newStsPolicy) throws ClientException {
        return (StsPolicy)this.send(HttpMethod.PUT, newStsPolicy);
    }

    @Override
    public IStsPolicyRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IStsPolicyRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

