/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.EducationUser;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationUserCollectionPage;
import com.microsoft.graph.requests.extensions.EducationUserCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EducationUserCollectionResponse;
import com.microsoft.graph.requests.extensions.EducationUserRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionRequest;
import java.util.List;

public class EducationUserCollectionRequest
extends BaseCollectionRequest<EducationUserCollectionResponse, IEducationUserCollectionPage>
implements IEducationUserCollectionRequest {
    public EducationUserCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationUserCollectionResponse.class, IEducationUserCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IEducationUserCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EducationUserCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationUserCollectionPage get() throws ClientException {
        EducationUserCollectionResponse response = (EducationUserCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EducationUser newEducationUser, ICallback<? super EducationUser> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EducationUserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEducationUser, callback);
    }

    @Override
    public EducationUser post(EducationUser newEducationUser) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EducationUserRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEducationUser);
    }

    @Override
    public IEducationUserCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IEducationUserCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IEducationUserCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IEducationUserCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationUserCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IEducationUserCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IEducationUserCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IEducationUserCollectionPage buildFromResponse(EducationUserCollectionResponse response) {
        EducationUserCollectionRequestBuilder builder = response.nextLink != null ? new EducationUserCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationUserCollectionPage page = new EducationUserCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

